/* vim: set sw=4 ts=4 noet: -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

#include <qcommon/qcommon.h>
#include <dg/dg.h>
#include <dg/dg_delta_tables.h>
#include <dg/dg_delta_encoding.h>
#include <dg/dg_types.h>
#include <dg/dg_logs.h>

///////////////////////////////////////////////////////////////////////////////
// Delta Encoding code

_field_table_t _dg_field_encoding;
 field_table_t  dg_field_encoding;
fieldname_map_t dg_fieldname_map;

void DG_InitDeltaTables()
{
	int i;
	dg_cluster_t *cl;

	// initialize the temp table
	for (i=0, cl = &dg_clusters[0]; cl->num_fields > 0 ; i++, cl++) {
		for (int j=0; j < cl->num_fields; j++) {
			_dg_field_encoding[string(cl->fields[j].name)] = cl;
		}
	}

	// initialize the real table
	dg_field_t field;
	field.type = DF_EDICT_PTR;
	dg_field_stack_t s;
	DG_InitFieldStack(&s);

	object_init(&s, &field);

	/*
	for (field_table_t::iterator it = dg_field_encoding.begin();
		 it != dg_field_encoding.end(); it++) {
		DB(0) << "key " << it->first << " = bit " 
			  << (it->second ? it->second->index : 0) <<endl;
	}
	*/
}

void DG_MakeInitDeltaMask(DG_Edict *dg_obj)
{
	// Calculate the fields that a "new" copy of this object sets. This way
	// we don't have to send the entire edict for new objects.
	// (Note: It is OK if it sets some fields to 0 even though this is
	// indistinguishable from not being set, since when "unpacked" the
	// initial value will be 0 anyway; we only care about difference from 0)
	static bool              inited = false;
	static edict_t           tmp_edict;
	static gclient_t         tmp_client;
	static dg_field_t        edict_fld;
	static dg_field_stack_t  init;
	if (!inited) {
		memset((void *)&tmp_edict, 0, sizeof(tmp_edict));
		memset((void *)&tmp_client, 0, sizeof(tmp_client));
		edict_fld.type = DF_EDICT_PTR;
		DG_InitFieldStack(&init);
		inited = true;
	}

	edict_t *ent = dg_obj->m_Entity;
	ASSERT(ent);

	/*
	INFO << "INIT:" << endl;
	cout << ent << endl;
	*/

	if (ent->client) {
		tmp_edict.client = &tmp_client;
	} else {
		tmp_edict.client = NULL;
	}
	dg_fields isdirty;
	object_is_dirty(&init, &isdirty, &edict_fld, 
					(byte *) &tmp_edict, (byte *) ent);

	//
	// Possibly record delta info for encoding table info
	//
	if (g_QuakePreferences.deltas) {
		DeltaEncodingEntry e(true, ent->is_replica, ent->guid,
							 ent->classname);
		for (dg_fields::iterator it = isdirty.begin(); it != isdirty.end(); it++) {
				e.fields.push_back( dg_fieldname_map[*it] );
			}
		LOG(DeltaEncodingLog, e);
	}
	// -----

	DG_MakeDeltaMask(dg_obj, &isdirty);

	// HACK: We need someway to keep track of the "initial" delta mask
	// needed to construct this object. In reality, we probably don't need
	// this since each "type" of object will know how to construct itself
	// from scratch with a "full" delta mask, but since we have no idea
	// which fields are required for each object in quake, just encode it
	// emperically.
	dg_obj->m_InitDeltaMask.Merge(dg_obj->GetDeltaMask());
	dg_obj->ClearDeltaMask();
	// every object must have a classname set!
	ASSERT( dg_obj->m_InitDeltaMask.IsSet( _dg_field_encoding[string("classname")]->index ) || dg_obj->m_InitDeltaMask.IsSet( NUM_FIELDS-1 ) );
}

void DG_MakeDeltaMask(GObject *obj, dg_fields *fields)
{
	for (dg_fields::iterator it = fields->begin();
		 it != fields->end(); it++) {
		if (dg_field_encoding.find(*it) == dg_field_encoding.end()) {
			WARN << "unknown field encoded: " << *it << endl;
			
			// don't know about this field. use the special bit in the
			// bitmask which says "screw it, encode everything"
			obj->SetDeltaMaskField(NUM_FIELDS-1);
			return;
		} else {
			dg_cluster_t *cl = dg_field_encoding[*it];
			if (!cl) {
				//DB(0) << "UNKNOWN key: " << *it << endl;
				// don't know about this field. use the special bit in the
				// bitmask which says "screw it, encode everything"
				obj->SetDeltaMaskField(NUM_FIELDS-1);
			} else {
				obj->SetDeltaMaskField(cl->index);
			}
		}
	}
}

void DG_MakeEncodeSet(const DeltaMask *primary, dg_fields *to_encode)
{
	int i;
	dg_cluster_t *cl;

	// special secondary bit that means "encode all"
	if ( primary->IsSet(NUM_FIELDS-1) ) {
		to_encode->clear(); // empty means encode all
		return;
	}
	
	for (i=0, cl = &dg_clusters[0]; 
		 cl->num_fields > 0 ; i++, cl++) {
		if (primary->IsSet(i)) {
			for (int j=0; j < cl->num_fields; j++) {
				to_encode->insert(cl->fields[j].key);
			}
		}
	}
}
