/* vim: set sw=4 ts=4 noet: -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

#ifndef QUAKE_ADAPTOR_H
#define QUAKE_ADAPTOR_H

#include <game/g_local.h>
#include <om/GameAdaptor.h>

class DG_ObjStore;
class DG_Edict;

extern double g_AvgFrameInterval;

class QuakeAdaptor : public GameAdaptor
{
    DG_ObjStore *m_DG_Edicts, *m_Half_Edicts;
public:
    QuakeAdaptor();

    uint32 GetSendInterval() { return (uint32) g_AvgFrameInterval; }

    ObjectStore* GetObjectStore() { return m_DG_Edicts;  }
    ObjectStore* GetPendingStore() { return m_Half_Edicts;  }

    GObject *Construct(GObjectInfoIface *info,
					   Packet *pkt, 
					   const DeltaMask& mask, 
					   SIDMap *unresolved);

	void FillInterestsDHT(InterestList *reg,
						  InterestList *unreg,
						  GUIDMap *reg_assoc,
						  InterestMap *curr);

	void FillInterests(InterestList *reg,
					   InterestList *unreg,
					   GUIDMap *reg_assoc,
					   InterestMap *curr);
    void     Destroy(guid_t guid);
    void     CheckInvariants();
	void     InstallTerminalHandlers(InputHandlers *tofill);
};

#endif
