/* vim: set sw=4 ts=4 noet: -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

#ifndef DG_OBJSTORE_H
#define DG_OBJSTORE_H

#include <game/g_local.h>
#include <om/GameAdaptor.h>

///////////////////////////////////////////////////////////////////////////////

edict_t *debug_get_entity(GObject *obj);
edict_t *debug_get_sentity(GObject *obj);

///////////////////////////////////////////////////////////////////////////////

class DG_ObjStore : public ObjectStore
{
private:
    GObjectMapIter m_Iter;
    GObjectMap m_Objmap;
    qboolean   m_IsPending;
public:
    DG_ObjStore(qboolean pending);

    void Begin();
    GObject *Next();
    GObject *Find(guid_t guid);
    void _ManagerAdd(GObject *obj);
    void _ManagerRemove(guid_t guid);
    void Destroy(guid_t guid);

    void _ApplicationAdd(GObject *obj);
    void _ApplicationRemove(guid_t guid);

    void Dump();
};

#endif
