#ifndef ALL_COMMON__H
#define ALL_COMMON__H

extern const char g_QuakeVersion[];
extern const char g_QuakeBuildTime[];

#define SPAWN_DEFAULT   'd' // quake default (farthest or random)
#define SPAWN_TYPEBASED 't' // monsters get fixed spawn points
#define SPAWN_RANDOM    'r' // force random spawn
#define SPAWN_ITEM      'i' // allow spawning by items

// start ashwin
typedef struct {
     int randseed;       // random seed -- hopefully quake doesn't override...
     
     int nservers;       // hacky parameter to do object ownership distribution initially...
     bool is_master;     // hacky parameter to do object ownership distribution initially...
     bool client;        // true if don't start mercury stuff (act as normal client)
     char master_ip[40]; // hacky parameter to specify the master server ip (port = 50000) (for slaves)
     int  nbots;         // number of bots spawned...
     int  nmonsters;     // number of bots that are monsters
     bool fightmonsters; // bots only fight monsters and vis versa
     char spawn_type;    // type of spawn
     bool jeffai;        // use jeff and justin's AI for acebots
     int  timelimit;     // that timelimit cvar causes segfaults because the "map" string is new! 
     int  framelimit;    // max number of frames to run (runs for min of timelimit and framelimit)
     bool disable_remote_multicast; // if true, multicast effects (most SFX won't be stored in a buffer to be sent to replica clients)
     bool enable_looking_at; // if true, quake will print the object a player is looking at
     
     bool dg_record_demo;     // if true, each distributed server will record a "partial" demo
     char dg_merge_demos [32];    // merge demo files made using the record demo option
     char dg_demo_dir [1024]; // directory where all demo files are located
     char dg_demo_output [1024]; // output demo file
     int  dg_demo_player;    // whose perspective should we show the demo from
     
     // predictive pub/sub params
     float subpred_player;
     float subpred_monster;
     float subpred_missile;

     float pubpred_player;
     float pubpred_monster;
     float pubpred_missile;
     
     int subttl_player;
     int subttl_monster;
     int subttl_missile;
     
     int pubttl_player;
     int pubttl_monster;
     int pubttl_missile;
     int pubttl_item;
     
     char routing_hubs[256];
     // dimension stripping
     char stripe_hubname[256]; // something other than x,y,z
     char stripe_dimname[256]; // x, y, z, "" = none
     int stripes_x;
     int stripes_y;
     int stripes_z;
     
     int stripe_dim; // (0 = x, 1 = y, 2 = z)
     int stripes[3];

     // dht options
     bool dht;
     char dht_hub[256];
     int  dht_buckets;
     
     // precomputing bboxes
     bool  bbox;
     char  bbox_min[256], bbox_max[256];
     float bbox_unit;
     float bbox_xystep, bbox_zstep;
     char  bbox_file[256];

     // calculate precomputed bbox accuracy
     bool  bbox_acc_test;
     
     // how to partition items amongst the slaves
     char  item_partition_method;
     
     // precomputing delta fields
     bool  deltas;
     
     bool dump_initial;         // just dump initial interests and exit
     bool record_obj_interests; // record primary object pos/bbox each frame
     bool record_obj_deltas;    // record object deltas each frame
     
     // pubsub simulator options
     bool  pubsubsim;
     float pubsubsim_subdist;
     float pubsubsim_pubdist;
     bool  pubsubsim_noselfpub;

     // playable map area calculation
     int   calc_playable_area; // (num samples)
     
     // disable frame-rate adjustment
     bool  nofradjust;
     
     // disable the startup and use of colyseus (implied by
     // bbox and bbox_acc_test and deltas and client).
     bool  disable_colyseus;
     char  visualizer_ip[40]; // specify the visualizer server ip (port = 60000)
     
     char benchmark_patternstr[1024];
     char *benchmark_patterns[255];
} qpref_t;

extern qpref_t g_QuakePreferences;
// end ashwin

#endif // ALL_COMMON__H
