///////////////////////////////////////////////////////////////////////
//
//  ACE - Quake II Bot Base Code
//
//  Version 1.0
//
//  This file is Copyright(c), Steve Yeager 1998, All Rights Reserved
//
//
//	All other files are Copyright(c) Id Software, Inc.
//
//	Please see liscense.txt in the source directory for the copyright
//	information regarding those files belonging to Id Software, Inc.
//	
//	Should you decide to release a modified version of ACE, you MUST
//	include the following text (minus the BEGIN and END lines) in the 
//	documentation for your modification.
//
//	--- BEGIN ---
//
//	The ACE Bot is a product of Steve Yeager, and is available from
//	the ACE Bot homepage, at http://www.axionfx.com/ace.
//
//	This program is a modification of the ACE Bot, and is therefore
//	in NO WAY supported by Steve Yeager.

//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Steve Yeager immediately, via
//	the ACE Bot homepage.
//
//	--- END ---
//
//	I, Steve Yeager, hold no responsibility for any harm caused by the
//	use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
//
//  I also wish to thank and acknowledge the great work of others
//  that has helped me to develop this code.
//
//  John Cricket    - For ideas and swapping code.
//  Ryan Feltrin    - For ideas and swapping code.
//  SABIN           - For showing how to do true client based movement.
//  BotEpidemic     - For keeping us up to date.
//  Telefragged.com - For giving ACE a home.
//  Microsoft       - For giving us such a wonderful crash free OS.
//  id              - Need I say more.
//  
//  And to all the other testers, pathers, and players and people
//  who I can't remember who the heck they were, but helped out.
//
///////////////////////////////////////////////////////////////////////
	
///////////////////////////////////////////////////////////////////////
//
//  acebot_ai.c -      This file contains all of the 
//                     AI routines for the ACE II bot.
//
//
// NOTE: I went back and pulled out most of the brains from
//       a number of these functions. They can be expanded on 
//       to provide a "higher" level of AI. 
////////////////////////////////////////////////////////////////////////

#include <vector>
#include <algorithm>
#include <game/g_local.h>
//#include "g_local.h"
#include <game/m_player.h>
#include <dg/dg.h>
#include <util/Benchmark.h>

#include "acebot.h"

///////////////////////////////////////////////////////////////////////
// Main Think function for bot
///////////////////////////////////////////////////////////////////////
void ACEAI_Think (edict_t *self)
{
	usercmd_t	ucmd;
	// JEFF_JUSTIN_BEGIN
	int r;
	// JEFF_JUSTIN_END

	// Set up client movement
	VectorCopy(self->client->ps.viewangles,self->s.angles);
	VectorSet (self->client->ps.pmove.delta_angles, 0, 0, 0);
	memset (&ucmd, 0, sizeof (ucmd));
	// Jeff mod: allow for chasing same player if already has a ptr
	//self->enemy = NULL;
	// Jeff end
	self->movetarget = NULL;
	
	// Force respawn 
	if (self->deadflag)
	{
		self->client->buttons = 0;
		ucmd.buttons = BUTTON_ATTACK;
	}
	
	if(self->state == STATE_WANDER && self->wander_timeout < level.time)
	  ACEAI_PickLongRangeGoal(self); // pick a new long range goal

	// Kill the bot if completely stuck somewhere
	if(VectorLength(self->velocity) > 37) //
		self->suicide_timeout = level.time + 10.0;

	if(self->suicide_timeout < level.time)
	{
		self->health = 0;
		player_die (self, self, self, 100000, vec3_origin);
	}
	
	// Find any short range goal
	ACEAI_PickShortRangeGoal(self);
	
	// JEFF_JUSTIN_BEGIN
	if (self->deadflag == DEAD_NO) {
	    if (g_QuakePreferences.jeffai) {
		r = rand() % 100;
		float percent_health = (float)self->health/self->max_health;
		if ( percent_health >= 0.5 && r < 90 && ACEAI_FindEnemy(self) ) {
		    // I am strong, 90% chance of attacking whoever i see
		    ACEAI_ChooseWeapon(self);
		    ACEMV_Attack (self, &ucmd);
		} else if ( self->health > 50 && percent_health < 0.5 && r < (int)(90*percent_health) && ACEAI_FindEnemy(self)) {
		    // I am below 50% health, look for items to boost me
		    ACEAI_ChooseWeapon(self);
		    ACEMV_Attack (self, &ucmd);
		} else if ( self->health <= 50 && r < 99 && ACEAI_FindEnemy(self)) {
		    // I am almost dead -- kamakazie!
		    ACEAI_ChooseWeapon(self);
		    ACEMV_Attack (self, &ucmd);
		}
		else
		    {
			// Execute the move, or wander
			if(self->state == STATE_WANDER)
			    ACEMV_Wander(self,&ucmd);
			else if(self->state == STATE_MOVE)
			    ACEMV_Move(self,&ucmd);
		    }
	    }
	    // JEFF_JUSTIN_END
	    else {
		// Look for enemies
		
		if(ACEAI_FindEnemy(self))
		    {	
			ACEAI_ChooseWeapon(self);
			ACEMV_Attack (self, &ucmd);
		    }
		else
		    {
			// Execute the move, or wander
			if(self->state == STATE_WANDER)
			    ACEMV_Wander(self,&ucmd);
			else if(self->state == STATE_MOVE)
			    ACEMV_Move(self,&ucmd);
		    }
		
	    }	
	}
	//debug_printf("State: %d\n",self->state);

	// set approximate ping
	ucmd.msec = 75 + floor (random () * 25) + 1;

	// Jeff Mod: don't need this
	// show random ping values in scoreboard
	//self->client->ping = ucmd.msec;
	// Jeff End

	// set bot's view angle
	ucmd.angles[PITCH] = ANGLE2SHORT(self->s.angles[PITCH]);
	ucmd.angles[YAW] = ANGLE2SHORT(self->s.angles[YAW]);
	ucmd.angles[ROLL] = ANGLE2SHORT(self->s.angles[ROLL]);
	
	// send command through id's code
	ClientThink (self, &ucmd);
	
	self->nextthink = level.time + FRAMETIME;
}

///////////////////////////////////////////////////////////////////////
// Evaluate the best long range goal and send the bot on
// its way. This is a good time waster, so use it sparingly. 
// Do not call it for every think cycle.
///////////////////////////////////////////////////////////////////////
void ACEAI_PickLongRangeGoal(edict_t *self)
{

	int i;
	int node;
	float weight,best_weight=0.0;
	int current_node,goal_node = INVALID;
	edict_t *goal_ent = 0;
	float cost;
	
	// look for a target 
	current_node = ACEND_FindClosestReachableNode(self,NODE_DENSITY,NODE_ALL);

	self->current_node = current_node;
	
	if(current_node == -1)
	{
		self->state = STATE_WANDER;
		self->wander_timeout = level.time + 1.0;
		self->goal_node = -1;
		return;
	}

	///////////////////////////////////////////////////////
	// Items
	///////////////////////////////////////////////////////
	for(i=0;i<num_items;i++)
	{
		if(item_table[i].ent == NULL || item_table[i].ent->solid == SOLID_NOT) // ignore items that are not there.
			continue;
		
		cost = ACEND_FindCost(current_node,item_table[i].node);
		
		if(cost == INVALID || cost < 2) // ignore invalid and very short hops
			continue;
	
		weight = ACEIT_ItemNeed(self, item_table[i].item);

		// If I am on team one and I have the flag for the other team....return it
#ifdef ASHWIN_CTF
		if(ctf->value && (item_table[i].item == ITEMLIST_FLAG2 || item_table[i].item == ITEMLIST_FLAG1) &&
		  (self->client->resp.ctf_team == CTF_TEAM1 && self->client->pers.inventory[ITEMLIST_FLAG2] ||
		   self->client->resp.ctf_team == CTF_TEAM2 && self->client->pers.inventory[ITEMLIST_FLAG1]))
			weight = 10.0;
#endif

		weight *= random(); // Allow random variations
		weight /= cost; // Check against cost of getting there
				
		if(weight > best_weight)
		{
			best_weight = weight;
			goal_node = item_table[i].node;
			goal_ent = item_table[i].ent;
		}
	}

	///////////////////////////////////////////////////////
	// Players
	///////////////////////////////////////////////////////
	// This should be its own function and is for now just
	// finds a player to set as the goal.

	edict_t *plr ;
	
	DG_BeginPlayerIter();
	while (plr = DG_GetNextPlayer()) {
		if(plr == self)
			continue;

		node = ACEND_FindClosestReachableNode(plr,NODE_DENSITY,NODE_ALL);
		// this seems to happen in some rare circumstances
		// (weird/small map..)
		if (node < 0)
		    continue;

		cost = ACEND_FindCost(current_node, node);

		if(cost == INVALID || cost < 3) // ignore invalid and very short hops
			continue;

#ifdef ASHWIN_CTF
		// Player carrying the flag?
		if(ctf->value && (plr->client->pers.inventory[ITEMLIST_FLAG2] || plr->client->pers.inventory[ITEMLIST_FLAG1]))
		  weight = 2.0;
		else
#endif
		  weight = 0.3; 
		
		weight *= random(); // Allow random variations
		weight /= cost; // Check against cost of getting there
		
		if(weight > best_weight)
		{		
			best_weight = weight;
			goal_node = node;
			goal_ent = plr;
		}	
	}

	// If do not find a goal, go wandering....
	if(best_weight == 0.0 || goal_node == INVALID)
	{
		self->goal_node = INVALID;
		self->state = STATE_WANDER;
		self->wander_timeout = level.time + 1.0;
		if(debug_mode)
			debug_printf("%s did not find a LR goal, wandering.\n",self->client->pers.netname);
		return; // no path? 
	}
	
	// OK, everything valid, let's start moving to our goal.
	self->state = STATE_MOVE;
	self->tries = 0; // Reset the count of how many times we tried this goal
	 
	if(goal_ent != NULL && debug_mode)
		debug_printf("%s selected a %s at node %d for LR goal.\n",self->client->pers.netname, goal_ent->classname, goal_node);

	ACEND_SetGoal(self,goal_node);

}

// Jeff Add: make searching for goals more efficient
struct goal_info
{
    edict_t *ent;
    float weight;
};

// sorts in descending order (highest weight first)
struct weighted_goal_less {
    bool operator() ( const goal_info& a, const goal_info& b) const {
	return a.weight > b.weight;
    }
};

// version of findradius tries to prefilter only for 
// items, rockets, and grenades
edict_t *findradius_goal (edict_t *from, vec3_t org, float rad)
{
    vec3_t	eorg;
    int		j;
    
    if (!from)
	from = g_edicts+1;
    else
	from++;
    for ( ; from < &g_edicts[globals.num_edicts]; from++) {
	if (!from->inuse)
	    continue;
	if (from->solid == SOLID_NOT)
	    continue;
	// continue if not an item, rocket, or grenade
	if (!from->item && 
	    !(from->s.effects & EF_ROCKET) && // (this is hacky :)
	    !(from->s.effects & EF_GRENADE))
	    continue;

	for (j=0 ; j<3 ; j++)
	    eorg[j] = org[j] - 
		(from->s.origin[j] + (from->mins[j] + from->maxs[j])*0.5);
	if (VectorLength(eorg) > rad)
	    continue;
	return from;
    }
    
    return NULL;
}

///////////////////////////////////////////////////////////////////////
// Pick best goal based on importance and range. This function
// overrides the long range goal selection for items that
// are very close to the bot and are reachable.
///////////////////////////////////////////////////////////////////////
void ACEAI_PickShortRangeGoal(edict_t *self)
{
	edict_t *target;
	float weight,best_weight=0.0;
	int index;
	static vector<goal_info> goals;
	
	goals.clear();
	// look for a target (should make more efficent later)
	target = NULL;
	while (target = findradius_goal(target, self->s.origin, 400)) {

	    // Missle avoidance code
	    // Set our movetarget to be the rocket or grenade fired at us. 
	    if(strcmp(target->classname,"rocket")==0 || 
	       strcmp(target->classname,"grenade")==0) {
		if(debug_mode) 
		    debug_printf("ROCKET ALERT!\n");
		
		self->movetarget = target;
		return;
	    }

	    // Record the item's worth
	    index = ACEIT_ClassnameToIndex(target->classname);
	    if (index == INVALID)
		continue;
	    weight = ACEIT_ItemNeed(self, index);
	    goal_info g;
	    g.ent = target;
	    g.weight = weight;

	    goals.push_back(g);
	}

	// now sort to find the "best" ones
	stable_sort(goals.begin(), goals.end(), weighted_goal_less());

	// now find the best one we can reach
	for (int i=0; i< goals.size(); i++) {
	    target = goals[i].ent;
	    if (ACEIT_IsReachable(self,target->s.origin)) {
		if (infront(self, target)) {
		    // found it!
		    self->movetarget = target;
		
		    if(debug_mode && self->goalentity != self->movetarget)
			debug_printf("%s selected a %s for SR goal.\n",
				     self->client->pers.netname, 
				     self->movetarget->classname);
		    self->goalentity = target;
		    return;
		}
	    }
	}
	
	/*
	while(target)
	{
		if(target->classname == NULL)
			return;
		
		// Missle avoidance code
		// Set our movetarget to be the rocket or grenade fired at us. 
		if(strcmp(target->classname,"rocket")==0 || 
		   strcmp(target->classname,"grenade")==0)
		{
			if(debug_mode) 
				debug_printf("ROCKET ALERT!\n");

			self->movetarget = target;
			return;
		}

		// First check if it is worth it.
		index = ACEIT_ClassnameToIndex(target->classname);
		weight = ACEIT_ItemNeed(self, index);		
		if (weight <= best_weight)
		    continue;
	
		// Then check if it is reachable, this is more expensive.
		if (ACEIT_IsReachable(self,target->s.origin))
		{
			if (infront(self, target))
			{
			    best_weight = weight;
			    best = target;
			}
		}

		// next target
		target = findradius(target, self->s.origin, 400);
	}

	if(best_weight)
	{
		self->movetarget = best;
		
		if(debug_mode && self->goalentity != self->movetarget)
			debug_printf("%s selected a %s for SR goal.\n",self->client->pers.netname, self->movetarget->classname);
		
		self->goalentity = best;

	}
	*/

}

// version of findradius which prefilters only for players
edict_t *findradius_player (edict_t *from, vec3_t org, float rad)
{
    vec3_t	eorg;
    int		j;
    
    if (!from)
	from = g_edicts+1;
    else
	from++;
    for ( ; from < &g_edicts[globals.num_edicts]; from++) {
	if (!from->inuse)
	    continue;
	if (from->solid == SOLID_NOT)
	    continue;
	if(!from->client ||  from->deadflag)
	    continue;
	
	for (j=0 ; j<3 ; j++)
	    eorg[j] = org[j] - 
		(from->s.origin[j] + (from->mins[j] + from->maxs[j])*0.5);
	if (VectorLength(eorg) > rad)
	    continue;
	return from;
    }
    
    return NULL;
}

///////////////////////////////////////////////////////////////////////
// Scan for enemy (simplifed for now to just pick any visible enemy)
///////////////////////////////////////////////////////////////////////
qboolean ACEAI_FindEnemy(edict_t *self)
{
    edict_t *plr ;

    // Jeff Add: (caching -- if chasing a valid player then continue)
    if (self->enemy &&         // chasing someone?
	self->enemy->inuse &&  // that is inuse...
	self->enemy->client && // and is a player...
	self->enemy->solid != SOLID_NOT && // and is currently solid...
	!self->enemy->deadflag && // and is not dead...
	gi.inPVS (self->s.origin, self->enemy->s.origin) && // can see them
	visible(self, self->enemy)) {
	//NOTE(same enemy!, 1);
	return true;
    } else {
	self->enemy = NULL;    // else find a new enemy
	//NOTE(diff enemy!, 1);
    }
    
    // Only look for players within 1024 units of us (at most 1/8 the map)
    plr = NULL;
    while (plr = findradius_player(plr, self->s.origin, 1024)) {
	if (plr == self)
	    continue;
	// if we are fighting monsters, then only attack other if they
	// are different class than us.
	if (g_QuakePreferences.fightmonsters && 
	    self->client->is_monster == plr->client->is_monster) {
	    continue;
	}

	if(gi.inPVS (self->s.origin, plr->s.origin) && // "Cheap" filter
	   visible(self, plr)) // This is more selective, but expensive
	{
	    self->enemy = plr;
	    return true;
	}

    }
   
    /*
    DG_BeginPlayerIter();
    while (plr = DG_GetNextPlayer()) {
	if(plr == NULL || plr == self || 
	   plr->solid == SOLID_NOT)
	    continue;
#ifdef ASHWIN_CTF
	if(ctf->value && 
	   self->client->resp.ctf_team == plr->client->resp.ctf_team)
	    continue;
#endif

	//DB(0) << self->client->pers.netname << " considering enemy: " 
	//      << plr->client->pers.netname << endl;

	if(!plr->deadflag && 
	   gi.inPVS (self->s.origin, plr->s.origin) && // "Cheap" filter
	   visible(self, plr)) // This is more selective
	{
	    //DB(0) << self->client->pers.netname << " picked enemy: " 
	    //      << plr->client->pers.netname << endl;

	    self->enemy = plr;
	    return true;
	}
    }
    */

    return false;
  
}

///////////////////////////////////////////////////////////////////////
// Hold fire with RL/BFG?
///////////////////////////////////////////////////////////////////////
qboolean ACEAI_CheckShot(edict_t *self)
{
	trace_t tr;

	tr = gi.trace (self->s.origin, tv(-8,-8,-8), tv(8,8,8), self->enemy->s.origin, self, MASK_OPAQUE);
	
	// Blocked, do not shoot
	if (tr.fraction != 1.0)
		return false; 
	
	return true;
}

///////////////////////////////////////////////////////////////////////
// Choose the best weapon for bot (simplified)
///////////////////////////////////////////////////////////////////////
void ACEAI_ChooseWeapon(edict_t *self)
{	
	float range;
	vec3_t v;
	
	// if no enemy, then what are we doing here?
	if(!self->enemy)
		return;
	
	// jeff: change: no good if we don't have perfect aim!
	// always favor the railgun
	/*
	if(ACEIT_ChangeWeapon(self,FindItem("railgun")))
		return;
	*/

	// Base selection on distance.
	VectorSubtract (self->s.origin, self->enemy->s.origin, v);
	range = VectorLength(v);
		
	// Longer range 
	if(range > 300)
	{
		// choose BFG if enough ammo
		if(self->client->pers.inventory[ITEMLIST_CELLS] > 50)
			if(ACEAI_CheckShot(self) && ACEIT_ChangeWeapon(self, FindItem("bfg10k")))
				return;

		if(ACEAI_CheckShot(self) && ACEIT_ChangeWeapon(self,FindItem("rocket launcher")))
			return;
	}

	// jeff: prefer rocket launcher to this
	if(ACEIT_ChangeWeapon(self,FindItem("railgun")))
		return;
	
	// Only use GL in certain ranges and only on targets at or below our level
	if(range > 100 && range < 500 && self->enemy->s.origin[2] - 20 < self->s.origin[2])
		if(ACEIT_ChangeWeapon(self,FindItem("grenade launcher")))
			return;

	if(ACEIT_ChangeWeapon(self,FindItem("hyperblaster")))
		return;
	
	// Only use CG when ammo > 50
	if(self->client->pers.inventory[ITEMLIST_BULLETS] >= 50)
		if(ACEIT_ChangeWeapon(self,FindItem("chaingun")))
			return;
	
	if(ACEIT_ChangeWeapon(self,FindItem("machinegun")))
		return;
	
	if(ACEIT_ChangeWeapon(self,FindItem("super shotgun")))
		return;
	
	if(ACEIT_ChangeWeapon(self,FindItem("shotgun")))
   	   return;
	
	if(ACEIT_ChangeWeapon(self,FindItem("blaster"))) {
	    //DB(0) << "chose weapon blaster" << endl;
	    return;
	} /*else {
	    DB(0) << "failed to choose weapon: " 
		  << " ent->client->pers.weapon=" << self->client->pers.weapon
		  << " ent->client->pers.inventory[ITEM_INDEX(item)]=" 
		  << self->client->pers.inventory[ITEM_INDEX(FindItem("blaster"))]
		  << " item->ammo=" << FindItem("blaster")
		  << " g_select_empty->value=" << g_select_empty->value
		  << endl;
		  }*/
	
	return;

}
