#!/usr/bin/perl
#
# Script to build the colyseus-quake distribution
# just copied from Merc/DistributionMaker.pl... if possible,
# factor out the common part into a .pm module...

use strict;
use Getopt::Std;
use vars qw ($opt_c $opt_m $opt_t $opt_T $opt_n);

getopts("cmt:T:n");

our $CLEAN   = defined $opt_c;
our $COMPILE = defined $opt_m;
our $TOPDIR  = defined $opt_t ? $opt_t : ".";
our $TMPDIR  = defined $opt_T ? $opt_T : "$ENV{HOME}/tmp";
our $DONT_REMOVE = defined $opt_n;
our $VERSION = GetVersion();
our $PWD = $ENV{PWD};
#################################################################

our @allfiles = GetDistFiles($TOPDIR);

my $IDSDIR = "$TMPDIR/id-source";
if (!$DONT_REMOVE) { 
    system ("rm -rf $IDSDIR");
}
system ("mkdir -p $IDSDIR") && die "error while 'mkdir -p Merc': $!";
foreach my $f (@allfiles) {
    my ($d, $b) = ($f =~ m|^(.*)/([^/]+)$|);
    if ($d && ! -d "$IDSDIR/$d") {
	system("mkdir -p $IDSDIR/$d") && die "can't mkdir $d";
    }
    if (!-f "$IDSDIR/$d/$b" or (`diff -q $f $IDSDIR/$d/$b 2>/dev/null` ne "")) {
	print STDERR "*** copying $f\n";
	system("cp -f $f $IDSDIR/$d") && die "can't copy $f";
    }
}

if ($CLEAN) {
    chdir ("$IDSDIR");
    system ("make clean");
}
if ($COMPILE) { 
    chdir ("$IDSDIR");
    system ("sh distmake.sh") && die "make did not succeed: $!";
}
chdir ($TMPDIR);
system("tar czf colyseus-quake2-$VERSION.tar.gz id-source") && die "can't tar";
chdir ($PWD);
# system("rm -rf colyseus-util");

########################################################################

sub GetVersion() {
    my $vstr = `grep g_QuakeVersion version.c`;
    if ($vstr =~ /"([\d\.]+)"/) { 
	return $1;
    }
    else {
	die "no version found in version.c";
    }
}

sub ScanMakefile($) { 
    my $makefile = shift;
    my ($line, $fstr);

    open F, $makefile or do { 
	print STDERR "** $makefile does not exist\n";
	return ();
    };

    while (<F>) { 
	chomp;
	next if !/DIST_FILES\s+=\s+(.*)$/;
	$line = $fstr = $1;
	$fstr =~ s/\\$//;

	while ($line =~ /\\$/) {
	    $line = <F>;
	    chomp $line;
	    last if (!defined $line or $line =~ /^\s*$/);
	    $fstr .= " $line";
	    $fstr =~ s/\\$//;
	}
    }

    my @files = ("Makefile");
    push @files, split (/\s+/, $fstr);
    return @files;
}

sub GetDistFiles($) {
    my $dir = shift;
    my @files = ();
    
    foreach my $df (ScanMakefile("$dir/Makefile")) {
	foreach my $f (glob "$dir/$df") { 
	    if (-d $f) { 
		push @files, GetDistFiles($f);
	    }
	    else {
		push @files, $f;
	    }
	}
    }
    return @files;
}
    
