#ifndef __UTIL_COMMON__H
#define __UTIL_COMMON__H   

#include <exception>
#include <stdexcept>
#include <cstdlib>
#include <cstdio>

#ifndef _WIN32
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#endif

#include <util/types.h>
#include <util/debug.h>

#define SIMULATION_MODE 's'
#define IMPLEMENTATION_MODE 'r'

#define STR_EQ(s1, s2)  (strcmp(s1.c_str(), s2.c_str()) == 0)
#define STR_NEQ(s1, s2) (strcmp(s1.c_str(), s2.c_str()) != 0)

typedef int socket_t;
typedef unsigned int u32_t;
typedef unsigned long long u64_t; // platform-specifc ?
typedef int type_t;

#ifdef _WIN32
// #include <WS2tcpip.h>
#endif

// Beware: SOCKET is unsigned on Win32. Careful in conditionals.
#ifdef _WIN32
// typedef SOCKET         Socket;
#else
typedef int            Socket;
typedef long int       DWORD;
#endif  // ifdef _WIN32

#ifndef _WIN32
#pragma GCC poison TODO
#endif
#ifndef MIN
#define MIN(a, b)  ((a) < (b) ? (a) : (b))
#endif

#ifndef MAX
#define MAX(a, b) ((a) > (b) ? (a) : (b))
#endif

class Packet;

class Serializable {
public:
    virtual void    Serialize(Packet *pkt)  = 0;
    virtual uint32  GetLength()             = 0;
    virtual void    Print(FILE *stream)     = 0;

    virtual ~Serializable () {}
};

#endif /* __UTIL_COMMON__H */
