/* $Id: refcnt.cpp 3552 2007-03-07 00:45:37Z jeffpang $ */

/*
 *
 * Copyright (C) 1998 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#ifndef HAVE_LIBASYNC

#include "refcnt.h"

/*
 * XXX - workaround for egregious egcs bug.
 *
 * On OpenBSD, egcs does not support inline functions with static
 * variables properly.  For example, what we want is:
 *    class __globaldestruction_t {
 *      bool &started () { static bool val; return val; }
 *    public:
 *      ~__globaldestruction_t () { started () = true; }
 *      operator bool () { return started () }
 *    };
 * But that doesn't work, so we need a whole file just for one bit!
 */

bool __globaldestruction_t::started;

#endif

// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
