////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#ifndef __HUFFMAN_PACKET__H
#define __HUFFMAN_PACKET__H

#include <util/GPL/huffman.h>
#include <util/Packet.h>

/**
 * Huffman encoded packet. code derived from quake3 qcommon/msg.c and
 * qcommon/huffman.c.
 */
class HuffmanPacket  : public Packet {
protected:
    static huffman_t msgHuff;
    static bool msgInit;
    static void MSG_initHuffman();

    msg_t sb;
    int oldsize;
    int	overflows;

    void MSG_Init (msg_t *buf, byte *data, int length);
    void MSG_InitOOB( msg_t *buf, byte *data, int length );
    void MSG_Clear (msg_t *buf);
    void MSG_WriteData (msg_t *buf, const void *data, int length);
    void MSG_Bitstream( msg_t *buf );

    void MSG_WriteBits( msg_t *msg, int value, int bits );

    void MSG_WriteChar (msg_t *sb, int c);
    void MSG_WriteByte (msg_t *sb, int c);
    void MSG_WriteShort (msg_t *sb, int c);
    void MSG_WriteLong (msg_t *sb, int c);
    void MSG_WriteFloat (msg_t *sb, float f);

    void MSG_BeginReading (msg_t *sb);
    void MSG_BeginReadingOOB(msg_t *sb);

    int	MSG_ReadBits( msg_t *msg, int bits );

    int	MSG_ReadChar (msg_t *sb);
    int	MSG_ReadByte (msg_t *sb);
    int	MSG_ReadShort (msg_t *sb);
    int	MSG_ReadLong (msg_t *sb);
    float MSG_ReadFloat (msg_t *sb);
    void MSG_ReadData (msg_t *sb, void *buffer, int size);

    // XXX this is so annoying. we should get rid of that peek interface!
    byte peek;
    bool ispeek;

public:                  
    static const int DEFAULT_PACKET_SIZE = 1472; // UDP packet

    HuffmanPacket();
    HuffmanPacket(int size);
    HuffmanPacket(Packet *pkt);
    HuffmanPacket(const HuffmanPacket& other);
    virtual ~HuffmanPacket();

    void Serialize(Packet *pkt);
    uint32 GetLength();

    virtual uint32 GetSize();
    virtual void WriteBuffer(byte *buf, int len);
    virtual void ReadBuffer(byte *buf, int len);

    virtual void WriteByte(byte b); 
    virtual byte ReadByte();
    /** XXX our implementation assumes that a peek byte will always be
      followed immediately followed by more peek bytes or read
      bytes. reading other values will be INCORRECT! */
    virtual byte PeekByte();

    virtual void WriteBool (bool b);
    virtual bool ReadBool ();

    virtual void WriteShort(uint16 s);
    virtual uint16 ReadShort();

    virtual void WriteInt(uint32 i);
    virtual uint32 ReadInt();

    virtual void WriteIntNoSwap(uint32 i);
    virtual uint32 ReadIntNoSwap();

    virtual void WriteFloat(float f);
    virtual float ReadFloat();

    virtual void WriteString(string& s);
    virtual void ReadString(string& s);
};

#endif // __HUFFMAN_PACKET__H
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
