# -*- Mode:makefile; indent-tabs-mode:t -*-
#
# Contains variable declarations for the most part
# Feel free to override any of these variables in any of the SUBDIR files
TOPDIR = .

# class of release target: { debug | release | profile | pprof }
RELEASE=debug

ARCH = $(shell arch)
OS = $(shell uname)

# compilers
CC=gcc
CPP=g++

# define this if we are have libasync
#SFSDIR = $(HOME)/sfs

SFSLIBS = $(SFSDIR)/sfsmisc/.libs/libsfsmisc.a -lresolv -lnsl $(SFSDIR)/svc/.libs/libsvc.a $(SFSDIR)/crypt/.libs/libsfscrypt.a $(SFSDIR)/arpc/.libs/libarpc.a $(SFSDIR)/async/.libs/libasync.a

# global includes if u want any; the -I. thing is new.
INCLUDES = -I. -I$(HOME)/sfs $(if $(SFSDIR),-I$(SFSDIR)/async,)
DEFINES  = -D__$(ARCH)__ -D__$(OS)__ -DUSE_STL $(if $(SFSDIR),-DHAVE_LIBASYNC,)
LIBRARIES = $(if $(SFSDIR),$(SFSLIBS),) -Wl,-rpath-link,$(TOPDIR)

OPTFLAGS = -Wall -Wno-unused -Werror -fPIC -fno-strict-aliasing
ifeq ($(RELEASE),debug)
 OPTFLAGS += -DDEBUG -g 
else
ifeq ($(RELEASE),profile)
 OPTFLAGS += -pg -g
 LIBRARIES += -pg -g
else
ifeq ($(RELEASE),pprof)
 OPTFLAGS += -O2 -DNDEBUG
 LIBRARIES += -L$(HOME)/lib -L$(HOME)/local/lib -lprofiler
else
 OPTFLAGS += -O2 -DNDEBUG -DBENCHMARK_REQUIRED -DWARN_ASSERTIONS
endif
endif
endif
ifeq ($(OS),Darwin)
 OPTFLAGS += -Wno-long-double
 # try to include fink libraries on Mac OS X
 DEFINES += -I/sw/include
 LIBRARIES += -L/sw/lib
endif
CFLAGS   = $(DEFINES) $(INCLUDES) $(OPTFLAGS)
CPPFLAGS = -include $(TOPDIR)/magic.h $(DEFINES) $(INCLUDES) $(OPTFLAGS) -Wno-deprecated -Wno-reorder
LDFLAGS  = $(LIBRARIES)

# XXX do this -lunwind business only if the platform 
# has libunwind.so installed...
APP_LIBS = $(if $(SFSDIR),$(SFSLIBS),) -lpthread -lm -lz -lgmp -lgmpxx

ifeq  ($(OS),Linux)
LIBEXT := .so
AREXT := .a
endif
ifeq ($(OS),Darwin)
LIBEXT := .dylib
endif
ifeq ($(OS),Win32)
LIBEXT := .dll
endif

# nice little rules to do EVERYTHING! just make sure you name all 
# the code-sources as .cpp

srcs = $(wildcard *.cpp)
deps = $(patsubst %.cpp,.%.d,$(srcs))
objs = $(patsubst %.cpp,.%.o,$(srcs))

.%.o: %.cpp
	@echo "* Compiling $<"
	@$(CPP) -c $(CPPFLAGS) -o $@ $<

# make dependency files: the little 'sed' trick is required since
# we act more intelligent and prepend a 'dot' to the object files
.%.d: %.cpp
	@echo "+ Generating deps for $<"
	@$(CPP) $(CPPFLAGS) -MM $< > $@
	@perl -pi -e 'BEGIN { $$v = `dirname "$@"`; chomp $$v; } if (/:/) { $$_ = "$$v/.$$_"; }' $@

define LINK_template
	echo $(1)
	$$(if $(1),$$(CPP) -shared $$(OPTFLAGS) -o $$@ $$(filter %.o, $$+),)
endef

ifeq ($(OS),Linux)
LINK_SO = $(CPP) -shared $(OPTFLAGS) -o $@ $(filter %.o,$+) $(patsubst lib%.so,lib%.so,$(filter %.so,$+)) $(LDFLAGS)
else
ifeq ($(OS),Darwin)
LINK_SO = $(CPP) -dynamiclib $(OPTFLAGS) -o $@ $(filter %.o,$+) $(patsubst lib%.so,lib%.so,$(filter %.so,$+)) -lz $(LDFLAGS)
else
ifeq ($(OS),Win32)
LINK_SO := $(error Don't know how to link dynamic libs on windoze)
else
LINK_SO := $(error Unknown operating system)
endif
endif
endif

define LINK_A
ar rc $@ $(filter %.o,$+)
ranlib $@
endef

%.so: 
	@echo "+ Linking $@"
# link only when $? is defined (i.e., at least one dependency is newer),
# or when the target file is not present
	$(if $?,$(LINK_SO),$(if $(shell ls $@),,$(LINK_SO)))

%.a: 
	@echo "+ Archiving $@"
	$(if $?,$(LINK_A),$(if $(shell ls $@),,$(LINK_A)))

# make deps if not cleaning
ifneq ($(deps),)
ifneq ($(MAKECMDGOALS),clean)
-include $(deps)
endif
endif
