#!/usr/bin/perl

use strict;
use lib "$ENV{HOME}/Merc/scripts/";
use Travertine;
use Getopt::Std;
use vars qw($opt_i $opt_s $opt_e $opt_b $opt_u $opt_p $opt_n $opt_S);

$ENV{LD_LIBRARY_PATH} = "../..:$ENV{LD_LIBRARY_PATH}";

getopts("i:s:e:b:u:p:n:S");

our $MAX_NODES = $opt_n || 4;
my $INTERVAL  = $opt_i || 100;
my $SIZE      = $opt_s || 128;
my $EPOCH     = $opt_e || 5000;
my $BURSTSIZE = $opt_b || 1;
my $BURSTINT  = defined $opt_u ? $opt_u : 1;
my $PROTO     = $opt_p || "UDP";
my $SCHEDRR   = $opt_S;

#sub Run
#{
#    my ($args) = @_;
#
#    chdir($TOPDIR);
#    $ENV{LD_LIBRARY_PATH} .= ":./Merc";
#
#    psystem("echo $TOPDIR");
#    psystem("echo \$LD_LIBRARY_PATH");
#    psystem("pwd");
#    psystem("./Merc/util/packet-test/pkttest $args");
#}

my $common_args = "-v 0 --send_interval $INTERVAL --pkt_size $SIZE --epoch $EPOCH --burst_size $BURSTSIZE --burst_interval $BURSTINT --proto $PROTO";
if ($SCHEDRR) {
    $common_args .= " --sched-rr";
}

## start master
xtermexec("Master", "./pkttest $common_args localhost:30000 m $MAX_NODES");

sleep(2);

## start slaves
for (my $i=1; $i<$MAX_NODES; $i++) {
    my $port = 30000 + $i;
    xtermexec("Slave $i",
	      "./pkttest $common_args localhost:$port localhost:30000");
}

sleep(10000);

sub xtermexec
{
    my $title = shift;
    my $cmd   = shift;
    print "$cmd\n";
    system("xterm -T \"$title\" -e bash -c \"$cmd; echo '*** EXITED ***'; sleep 1000000\" &");
}
