#!/usr/bin/perl

use strict;
use lib "$ENV{HOME}/id-source/scripts/";
use lib "$ENV{HOME}/id-source/scripts/emulab";
require "$ENV{HOME}/id-source/scripts/inc.pl";
use conf;
use EmulabConf;
use Getopt::Std;
use vars qw($opt_i $opt_s $opt_e $opt_b $opt_u $opt_p);

our $EXP_NAME      = "games4lan";
our $MAX_NODES     = 4;

getopts("i:s:e:b:u:p:");

my $INTERVAL  = $opt_i || 100;
my $SIZE      = $opt_s || 128;
my $EPOCH     = $opt_e || 5000;
my $BURSTSIZE = $opt_b || 1;
my $BURSTINT  = defined $opt_u ? $opt_u : 1;
my $PROTO     = $opt_p || "UDP";

sub Run
{
    my ($args) = @_;

    chdir($TOPDIR);
    $ENV{LD_LIBRARY_PATH} .= ":./Merc";

    psystem("echo $TOPDIR");
    psystem("echo \$LD_LIBRARY_PATH");
    psystem("pwd");
    psystem("./Merc/util/packet-test/pkttest $args");
}

my $common_args = "-v 0 --send_interval $INTERVAL --pkt_size $SIZE --epoch $EPOCH --burst_size $BURSTSIZE --burst_interval $BURSTINT --proto $PROTO";

## start master
rsystem($USERNAME, "node0.$EXP_NAME.$GROUP.emulab.net",
	\&Run,  "$common_args node0:30000 m $MAX_NODES");

sleep(5);

## start slaves
for (my $i=1; $i<$MAX_NODES; $i++) {
    rsystem($USERNAME, "node$i.$EXP_NAME.$GROUP.emulab.net",
	    \&Run,  "$common_args node$i:30000 node0:30000");
}

sleep(10000);
