////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#include <Mercury.h>
#include <mercury/Scheduler.h>
#include <wan-env/RealNet.h>
#include <wan-env/WANMercuryNode.h>
#include <wan-env/WANScheduler.h>

#include <rpc/MercRPC.h>
#include <rpc/RealNetMarshaller.h>
#include <rpc/MercRPCDispatcher.h>

MercRPCServerDispatcher *d;
RealNetMarshaller *m;
WANMercuryNode *n;

uint32 rpcPort;

OptionType opts[] =
{
    { '/', "rpc-port", OPT_INT,
	"port that the rpc server listens on",
	&rpcPort, "12000", NULL },
	{ 0, 0, 0, 0, 0, 0, NULL },
};

int main(int argc, char **argv) {
    InitializeMercury(&argc, argv, opts);
    MercRPC_RegisterTypes();
    MercRPC_SetIsRPCServer(true);

    // set rpc listen address
    struct hostent *entry = gethostbyname(g_Preferences.hostname);
    if (entry)
	g_RPCAddr.m_IP = ((struct in_addr *) entry->h_addr)->s_addr;
    else
	g_RPCAddr.m_IP = inet_addr(g_Preferences.hostname);
    g_RPCAddr.m_Port = rpcPort; 

    DBG_INIT(&g_RPCAddr);

    // startup merc
    n = WANMercuryNode::GetInstance(g_Preferences.port);
    n->FireUp();
    while (!n->IsJoined()) {
	RealNet::DoWork();
	n->DoWork (10);
    }

    // start listening for app
    WANScheduler *sched = new WANScheduler();
    sched->SetNode(n);
    RealNet *net = new RealNet(sched, g_RPCAddr);
    net->StartListening(PROTO_TCP);

    // startup rpc marshaller
    m = new RealNetMarshaller(net);
    MercRPCMarshaller::Init(m);
    MercRPCServerDispatcher::Init(n);

    n->RegisterApplication(Application_ClientStub::GetInstance());

    // create rpc dispatcher
    d = MercRPCServerDispatcher::GetInstance();
    m->SetDispatcher(d);

    // loop on processing
    //int i = 0;
    while (true) {
	//INFO << i++ << endl;
	RealNet::DoWork(10);
	d->ProcessRPCs();
	n->DoWork(10);
    }

    return 0;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
