////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#ifndef __OPTIONS__H
#define __OPTIONS__H   

typedef struct {
    char    hostname[255];
    char    bootstrap[255];
    char    schema_string[1024];
    char    join_locations[1024];
    bool    succ_wait_alljoin;
    bool    aggressive_fingers;

    char    logger[255];
    int	    port;
    bool    use_cache;
    int     cache_type; /* really a cache_t */
    int     cache_size; 

    bool    use_softsubs;       // use softstate subs
    bool    enable_pubtriggers; // enable publication triggers

    //  bool    enable_puboverwriting; // enable publication triggers to be overwritten -- dont store stale pubs
    //  int     pub_lifetime;   // how long softstate pubs live for (msec)
    int     sub_lifetime;       // how long softstate subs live for (msec)
    bool    send_backpub;       // send a pub back to the creator (false = no)
    char    merctrans[255];     // transport proto to use for mercury
    bool    use_poll;           // use poll instead of select for waiting

    bool    msg_compress;       // enable message compression
    int     msg_compminsz;      // min size of messages to compress
    bool    latency;            // enable artificial latency 
    char    latency_file[255];  // file with artificial latencies
    int     max_tcp_connections;// max open tcp connections (xxx: only for async realnet now)

    bool    fanout_pubs;        // enable "fanning out" of range pubs
    bool    distrib_sampling;   // perform random-walk based sampling
    bool    do_loadbal;         // perform load balancing
    bool    loadbal_routeload;  // load balance using mercury's routing load
    float   loadbal_delta;      // keep load between mean/delta and mean*delta (delta >= sqrt(2))
    bool    self_histos;        // use self-generated histograms (dont rely on bootstrap)
    bool    nosuccdebug;        // disable periodic printout of succ info
} pref_t;

extern pref_t g_Preferences;

#endif /* __OPTIONS__H */
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
