require 'mercsim'
include Mercsim

n_tuples = 10
n_constraints = 10

def gen_num
    maxval = 1000
    minval = 0
    return minval + rand(maxval - minval)
end

def gen_tuples(n)
    tuples = []
    n.times do 
	tuples << Tuple.new(0, MercuryID.new(gen_num))
    end

    # tuples.each do |t| puts "#{t}"; end
    return tuples
end

def gen_constraints(n)
    constraints = []
    n.times do
	begin
	    one = gen_num
	    two = gen_num
	end until one != two

	if one > two then
	    one, two = two, one
	end
	constraints << Constraint.new(0, MercuryID.new(one), MercuryID.new(two))
    end
    # constraints.each do |c| puts "#{c}"; end
    return constraints
end

def test_overlaps(n)
    events = []
    interests = []
    
    tuples = gen_tuples(n)
    constraints = gen_constraints(n)

    n.times do 
	e = PointEvent.new
	t = tuples[rand(n)]
	e.AddTuple(t)

	events << e
    end
    # events.each do |e| puts "#{e}"; end

    n.times do
	i = Interest.new
	c = constraints[rand(n)]
	i.AddConstraint(c)

	interests << i
    end
    # interests.each do |i| puts "#{i}"; end
    
    events.each do |e|
	interests.each do |i| 
	    if i.Overlaps(e) then
		puts "Interest #{i.GetConstraint(0)} overlaps event #{e.GetConstraint(0).GetMin()}"
	    end
	end
    end
end

def func(n, t)
    puts "I am called at #{t}"
end
init_env ([$0] + ARGV)
sim = Simulator.new

sim.add_sim_task(proc { |n, t| puts "I am called on node #{n.GetAddress()} at #{t}"; }, 500)
sim.ProcessFor(10000)

#
# v = add(5, 7)
# puts v

# test_overlaps(10)
# sim = Simulator.new
# addr = IPEndPoint.new("128.2.203.210:20001")
# node = SimMercuryNode.new(sim, sim, addr)
# sim.AddNode(node)
