require 'test/unit'
require 'mercsim'
include Mercsim

class Array 
    def choose
	return at(rand(size))
    end
end

class Event
    def to_s ; GetConstraint(0).to_s ; end
end

class PointEvent 
    def to_s ; GetConstraint(0).to_s ; end
    def belongs_to(node,h=0)	
	nc = node.GetHubRanges()[h]
	ec = GetConstraint(h)

	return nc.Covers(ec.GetMin())
    end
end

class Node 
    def to_s ; return GetAddress().to_s ; end
end

class SimMercuryNode
    def to_s ; return GetAddress().to_s ; end
end

class RubyTestApp < DummyApp
    attr_accessor :store

    def initialize(node)
	super()
	@node = node
	@store = []
    end

    def EventRoute(ev,lasthop)
	#puts "#{@node} routing #{ev}"
	return 1
    end

    def EventAtRendezvous(ev, lasthop, nhops) 
	nev = ev.Clone
	#puts "#{@node} STORING #{nev}"
	@store << nev
	return EV_MATCH_AND_STORE
    end
end

def gen_num
    maxval = 10000
    minval = 0
    return minval + rand(maxval - minval)
end

module WorkloadGen
    def gen_tuple(h=0)
	return Tuple.new(h, MercuryID.new(gen_num))
    end

    def gen_constraint(h=0)
	begin
	    one = gen_num
	    two = gen_num
	end until one != two

	if one > two then
	    one, two = two, one
	end
	return Constraint.new(h, MercuryID.new(one), MercuryID.new(two))
    end

    def gen_event(hubs=[0])
	e = PointEvent.new
	hubs.each { |h| 
	    t = gen_tuple(h)
	    e.AddTuple(t)
	}
	return e
    end

    def gen_interest(hubs=[0])
	i = Interest.new
	hubs.each { |h| 
	    c = gen_constraint(h)
	    i.AddConstraint(c)
	}
	return i
    end    
end

def dump_sim_time(n, t)
    puts "Simulation time: #{t}"
end

# I need to make this a module and use mix-ins later
# because of the crazy way test/unit likes to operate
#
module MercuryTest
    def setup_common
	@nodes = []
	@nodes_by_addr = {}
	@apps = {}
	
	@sim   = nil         # simulator
	@bootstrap = nil     # bootstrap node
	@host = "gs203.sp.cs.cmu.edu"

	init_env([$0] + ARGV)
	set_preferences
	setup_simulator
	setup_bootstrap
    end
	

    def teardown_common
    end
    
    def set_preferences 
	Mercsim.g_Preferences.bootstrap = "#{@host}:65535"
	Mercsim.SuccessorMaintenanceTimeout = 50
	Mercsim.PeerPingInterval = 50
	Mercsim.PeerPongTimeout  = 150
    end
    
    def setup_bootstrap
	addr = IPEndPoint.new(Mercsim.g_Preferences.bootstrap)
	schema = Mercsim.g_BootstrapPreferences.schemaFile
	@bootstrap = BootstrapNode.new(@sim, @sim, addr, schema)
	@sim.AddNode(@bootstrap)
    end

    def setup_simulator
	@sim = Simulator.new

	# gah. managing memory is a bit of a pain here...
	# basically, anytime some ruby-object gets passed 
	# inside C++ and if C++ is not making a copy, then 
	# ruby GC kicks in and interacts in weird ways
	#
	# for now, i am disabling the GC since stuff aint much
	# memory intensive anyways
	#
	GC.disable  
	add_periodic(1000) { |n, t| puts "Simulation time: #{t}" }
    end

    def create_node_with_addr(addr)
	n = SimMercuryNode.new(@sim, @sim, addr)

	a = RubyTestApp.new(n)
	n.RegisterDummyApp(a)
	@apps[addr.to_s] = a 

	@sim.AddNode(n)
	@nodes << n
	@nodes_by_addr[addr.to_s] = n
	return n
    end

    def create_node
	index = @nodes.size
	addr = IPEndPoint.new("#{@host}:#{index}")
	return create_node_with_addr(addr)
    end

    def add_periodic(period, &block) 
	add_periodic_helper(period, block)
    end

    def add_periodic_helper(period, p)	
	@sim.add_task(period) do |n, t| 
	    ret = p.call(n, t)
	    if not ret 
		add_periodic_helper(period, p)
	    end
	end
    end
    private :add_periodic_helper

    def start_nodes(interval) 
	@nodes.each_index do |i|
	    @sim.add_task(interval * i) { @nodes[i].StartUp }
	end
	@sim.ProcessFor(interval * @nodes.size + 3000)
    end

    def get_hub_constraints
	c = @nodes[0].GetHubConstraints()[0]
	assert_not_nil c
	return [c.GetMin, c.GetMax]
    end

    def sorter_func(a,b) 
	ra, rb = [a, b].map { |x| x.GetHubRanges()[0].GetMin() }
	if ra == rb then 0
	elsif ra < rb then -1
	else 1
	end
    end

    def subtest_ranges_abut
	puts "Checking if ranges_abut"
	hubmin, hubmax = get_hub_constraints
	sorted = @nodes.sort { |a, b| sorter_func(a, b) }

	len = sorted.size
	sorted.each_index { |i| 
	    j = (i + 1) % len
	    max = sorted[i].GetHubRanges()[0].GetMax()
	    min = sorted[j].GetHubRanges()[0].GetMin()
	    assert(max == min || (max == hubmax and min == hubmin))

	    puts "#{sorted[i]} => #{sorted[i].GetHubRanges()[0]}"
	}
	puts ""
    end
    
    def subtest_ring_connected
	puts "Checking if ring is connected..."
	seen = {}
	node = @nodes[0]
	seen[node.GetAddress().to_s] = 1

	while true do 
	    succ = node.GetSuccessors(0)[0].addr
	    assert_not_nil(succ)

	    succ = succ.to_s
	    node = @nodes_by_addr[succ]
	    assert_not_nil(node)	    
	    break if seen.has_key?(succ)
	    seen[succ] = 1
	end 
	
	assert_equal(seen.size(), @nodes.size)
    end
    
    def xxx_test_nothing
	@sim.add_task(100) do |n, t| 
	    assert_equal(t.tv_sec, 0)
	    assert_equal(t.tv_usec, 100 * 1000)
	    assert_equal(n.GetAddress().to_s, Mercsim.SID_NONE.to_s)
	end
	add_periodic(150) { |n, t| puts "called at #{t}" }
	@sim.ProcessFor(1000)
    end
end

class TC_Routing < Test::Unit::TestCase
    include MercuryTest
    include WorkloadGen

    def setup
	setup_common
	@num_nodes = Mercsim.driver_prefs.nodes
	
	@num_nodes.times { create_node }    
	start_nodes(100)
    end

    def teardown
	teardown_common
    end

    def subtest_publications_routing
	puts "Checking if publications route correctly..."
	@events = [] 
	belongs = {}
	(@num_nodes * 2).times do 
	    e = gen_event
	    n = @nodes.choose

	    @nodes.each { |x| 
		if e.belongs_to(x)
		    belongs[e] = x
		    break
		end
	    }
	    n.SendEvent e
	    @events << e
	end
	max_hops = @num_nodes
	@sim.ProcessFor(max_hops * 50) # hm. this is the default latency value.

	# check if the events got to the correct places or not
	@events.each { |e| 
	    node = belongs[e]
	    assert_not_nil(node)
	    app = @apps[node.GetAddress().to_s]
	    assert_not_nil(app)

	    found = app.store.detect { |sev| 
		sev.GetConstraint(0).to_s == e.GetConstraint(0).to_s
	    }
	    assert(found, "event #{e} failed to route correctly. not present at #{node}")
	}
    end

    def subtest_subscriptions_routing 
	puts "Checking if subscriptions route correctly..."
	@interests = []
	belongs = {}
	(@num_nodes * 2).times do 
	    i = gen_interest
	    n = @nodes.choose

	    @nodes.each { |x| }
	end
    end

    def test_pubsub_routing_basic
	subtest_ranges_abut
	subtest_ring_connected
	# subtest_subscriptions_routing
	subtest_publications_routing
	#subtest_matching
    end
end

# run with the following arguments
#  ruby routing_tests.rb -- --measurement --schema test.cfg --histograms
#  --buckets 50 --verbosity -20 --nodes 4 
