%module(directors="1") mercsim
%feature("director") DummyApp;
%feature("director") Application;

%feature("director") OneClass;
%inline %{
    class OneClass {
	int x;
    public:
	OneClass (int x) : x (x) { }
        virtual ~OneClass () {}

	void stuff () { print (); }
	virtual void print () = 0;
    };
%}

// %feature("nodirector");     
// XXX: DONT DO THE ABOVE. IT DISABLES wrapper director class generation...

%{
#include <mercury/Event.h>
#include <mercury/Interest.h>
#include <mercury/Constraint.h>
#include <mercury/Tuple.h>
#include <mercury/MercuryNode.h>
#include <mercury/BootstrapNode.h>
#include <mercury/ObjectLogs.h>
#include <sim-env/Simulator.h>
#include <sim-env/SimMercuryNode.h>
#include <util/Options.h>
#include <mercury/options.h>
#include <mercury/Application.h>
#include <mercury/Parameters.h>
#include <Mercury.h>
#include <sstream>
%}

typedef unsigned long u_long;

%{
    class SpEvent : public SchedulerEvent {
	VALUE   m_RubyFunc;
    public:
	SpEvent (VALUE f) : m_RubyFunc (f) {
	    /*
	    rb_gc_mark (m_RubyFunc);

	    // Never mark. Never free. a memory leak of course.
	    // Dunno what will happen to stuff referenced by this block
	    // though...
	    RDATA(m_RubyFunc)->dfree = NULL;
	    RDATA(m_RubyFunc)->dmark = NULL;
	    */
	}

	virtual void Execute (Node& node, TimeVal& timenow) {
	    VALUE arg1 = SWIG_NewPointerObj ((void *) &node, SWIGTYPE_p_Node, 0);
	    VALUE arg2 = SWIG_NewPointerObj ((void *) &timenow, SWIGTYPE_p_TimeVal, 0);

	    rb_funcall (m_RubyFunc, rb_intern("call"), 2, arg1, arg2);
	}
    };
%}

/* some hopefully harmless stuff here */
%include <util/types.h>
%include <util/common.h>
%include <util/ID_common.h>
/* %include <util/TimeVal.h> */
%include <util/Environment.h>
%include <util/IPEndPoint.h>
%include <mercury/Neighbor.h>
%include <mercury/options.h>
%include <mercury/Parameters.h>
%include <mercury/BootstrapNode.h>

%include "typemaps.i"
%include "std_vector.i"
%include "std_string.i"

extern FILE* stderr;
extern FILE* stdout;


typedef enum {
    EV_NUKE,
    EV_MATCH,
    EV_STORE,
    EV_MATCH_AND_STORE
} EventProcessType;

typedef enum {
    IN_NUKE,
    IN_STORE,
    IN_TRIGGER,
    IN_STORE_AND_TRIGGER
} InterestProcessType;

class DummyApp {
public:
    DummyApp();

    virtual void JoinBegin (const IPEndPoint& succ);

    virtual void JoinEnd (const IPEndPoint& succ);
    virtual void LeaveBegin ();
    virtual void LeaveEnd ();

    virtual void RangeExpanded (const NodeRange& oldrange, const NodeRange& newrange);
    virtual void RangeContracted (const NodeRange& oldrange, const NodeRange& newrange);
    virtual int EventRoute(Event *ev, const IPEndPoint& lastHop);
    virtual int EventLinear(Event *ev, const IPEndPoint& lastHop);
    virtual EventProcessType EventAtRendezvous (Event *ev, const IPEndPoint& lastHop, int nhops);
    virtual void EventInterestMatch (const Event *ev, const Interest *in, const IPEndPoint& subscriber);
    virtual int InterestRoute (Interest *in, const IPEndPoint& lastHop);
    virtual int InterestLinear (Interest *in, const IPEndPoint& lastHop);
    virtual InterestProcessType InterestAtRendezvous (Interest *in, const IPEndPoint& lastHop);
    virtual bool IsLeaveJoinOK () ;
};

%define ADD_TO_STRING(klass) 
%extend klass { 
public:
    const char *__str__() { 
	static stringstream out;
	out.str("");  /* clear the stream */
	out << self;
	return out.str().c_str();
    }
}
%enddef

class MercuryID {
public:
   MercuryID (const MercuryID& b); 
   MercuryID (int si);

   MercuryID (const char *s, int base = 0);
};

%extend MercuryID {
public:
    bool __lt__ (const MercuryID& b) { return *self < b; }
    bool __le__ (const MercuryID& b) { return *self <= b; }
    bool __eq__ (const MercuryID& b) { return *self == b; }
};

typedef MercuryID Value;
ADD_TO_STRING(MercuryID)
struct TimeVal {
public:
    int tv_sec, tv_usec;
};

ADD_TO_STRING(TimeVal)

class Tuple {
public:
    Tuple (int attr, Value& v);
    Tuple (const Tuple &t);

    const Value& GetValue() const;
    int GetAttrIndex() const;
};
ADD_TO_STRING(Tuple)

class Constraint {
public:
    Constraint(int attr, Value min, Value max);
    Constraint(const Constraint &c);
    
    const Value& GetMin() const { return m_Min; }
    const Value& GetMax() const { return m_Max; }
    int   GetAttrIndex() const { return m_AttrIndex; }
    bool Covers (const Value& val) const ;
    bool Overlaps (const Constraint& cst) const;
    bool OverlapsNodeRange (const NodeRange& nr) const;

    Value GetSpan (const Value& absmin, const Value& absmax) const;
    Value GetOverlap (const Constraint& cst) const;
};

typedef Constraint NodeRange;
typedef Constraint Interval;

ADD_TO_STRING(Constraint)

namespace std {
    %template(Vectorcons) vector<Constraint>;
    %template(Vectornbr) vector<Neighbor>;
};

class Event {    
public:
    Event();

    virtual Event *Clone() const;

    uint32  m_TriggerCount; // DEBUG : Jeff [10/7] - number times this pub was triggered
    uint32  GetNonce() { return m_Nonce; }
    bool IsMatched() const { return m_Matched; }
    int GetNumConstraints ();
    Constraint *GetConstraint (int index) = 0;
    Constraint *GetConstraintByAttr (int attr_index);
};

ADD_TO_STRING(Event)

class MercuryEvent : public Event { 
public:
    MercuryEvent() {}
    void AddConstraint (Constraint& c);
    Constraint *GetConstraint (int index) ;
};

ADD_TO_STRING(MercuryEvent)

class PointEvent : public MercuryEvent {
public:
    PointEvent() {}

    void AddTuple(Tuple& t);
    Value *GetValueByAttr (int attr_index);
    Constraint *GetConstraint (int index) ;
};

ADD_TO_STRING(PointEvent)
ADD_TO_STRING(IPEndPoint)

class Interest {
public:
    Interest ();
    Interest (IPEndPoint& subscriber);

    void    AddConstraint(Constraint& c);
    Constraint* GetConstraintByAttr (int attr);    
    int GetNumConstraints ();

    Constraint* GetConstraint (int index);
    const IPEndPoint &GetSubscriber() const { return m_Subscriber; }

    bool Overlaps (Event *evt);

    bool IsEqual(Interest *);
    uint32 GetLifeTime() const { return m_LifeTime; }
    void SetLifeTime(uint32 lifetime) { m_LifeTime = lifetime; }
    uint32 GetNonce() const { return m_Nonce; }
};

ADD_TO_STRING(Interest)

%apply SWIGTYPE *DISOWN {Node& node};
%include <sim-env/Simulator.h>
%clear Node& node;

/*
%markfunc Simulator "mark_Simulator"
%header %{
    static void mark_Simulator (void* ptr) {
	Simulator *sim = (Simulator *) ptr;
	const NodeMap& nodes = sim->GetNodeMap ();

	cerr << "Marking simulator... for " << nodes.size () << " nodes" << endl;
	for (NodeMap::const_iterator it = nodes.begin (); it != nodes.end (); ++it) {
	    Node *n = it->second;
	    VALUE object = SWIG_RubyInstanceFor (n);

	    cerr << " trying to mark node " << n->GetAddress () << endl;
	    if (object != Qnil) {
		cerr << " **** hm. marking successful.. " << endl;
		rb_gc_mark(object);
	    }
	}
    }
%}
*/

%include <util/Options.h>

/* UPDATE: but maybe you can define 2 accessor methods just like swig does 
 * it for global variables .... */

/* mirroring variables between C++ and ruby using plain pointers doesn't seem 
 * possible. basically, internally, in any interpreted language, even a
 * primitive type may be represented in a very complex way. */

#if 0

/* expose this method */
void add_option(char shortletter, char *longword, int flags, char *comment, 
	int *varptr, char *default_val, char *val_to_set);

%{
    #define RUBY_DRIVER_PREFS_LENGTH 100
    static OptionType ruby_driver_prefs[RUBY_DRIVER_PREFS_LENGTH];
    static bool ruby_driver_prefs_initialized = false;
    static int ruby_driver_prefs_index = 0;

    void add_option(char shortletter, char *longword, int flags, char *comment, 
	    void *varptr, char *default_val, char *val_to_set) 
    {
	if (!ruby_driver_prefs_initialized) {
	    for (int i = 0; i < RUBY_DRIVER_PREFS_LENGTH; i++) {
		OptionType *opt = ruby_driver_prefs + i;
		memset (opt, 0, sizeof (OptionType));
	    }
	    ruby_driver_prefs_initialized = true;
	}

	if (ruby_driver_prefs_index >= RUBY_DRIVER_PREFS_LENGTH) {
	    Debug::die("No space for ruby options left! Maximum number of options allowed=%d\n", RUBY_DRIVER_PREFS_LENGTH);
	}

	OptionType *opt = ruby_driver_prefs + ruby_driver_prefs_index;
	opt->shortletter = shortletter;
	opt->longword = longword;
	opt->flags = flags;
	opt->comment = comment;
	opt->varptr = (void *) varptr;
	opt->default_val = default_val;
	opt->val_to_set = (void *) val_to_set;
	
	ruby_driver_prefs_index++;
    }

    void add(int x, int y, int *result) {
	*result = x + y;
    }
%}
#endif
%inline %{

    void test_director (OneClass *c) {
	c->stuff ();
	/*
	MercuryEvent *ev = new MercuryEvent ();
	app->EventRoute (ev, SID_NONE);
	*/
    }
%}

%inline %{
    struct DriverPrefs
    {
	int nodes;
	int inter_arrival_time;
    };

    struct DriverPrefs driver_prefs;
%}

%{
    OptionType g_DriverOptions [] = 
    {
	{ '#', "nodes", OPT_INT, "number of mercury nodes in the simulation",
	    &driver_prefs.nodes, "10" , NULL },
	{ '#', "arrive-int", OPT_INT, "inter-arrival interval (milliseconds)",
	    &driver_prefs.inter_arrival_time, "100" , NULL },
	{ 0, 0, 0, 0, 0, 0, 0 }
    };

    OptionType *g_TrulyAllOptions;

    void init_env (int argc, char **argv)
    {
	SID foo ("gs203.sp.cs.cmu.edu:65535");

	strcpy (g_ProgramName, *argv);
	DBG_INIT (&SID_NONE);

	// merge options
	OptionType **all_options = new OptionType *[2];
	all_options[0] = g_DriverOptions;
	all_options[1] = g_BootstrapOptions;

	g_TrulyAllOptions = MergeOptions (all_options, 2);
	delete[] all_options;

	// initialize mercury
	InitializeMercury (&argc, argv, g_TrulyAllOptions, true);

	RegisterEventTypes ();
	RegisterInterestTypes ();
	RegisterMessageTypes ();

	InitObjectLogs (foo);
    }
%}

%typemap(in) (int argc, char **argv) { 
    $1 = RARRAY($input)->len;
    $2 = (char **) malloc (($1 + 1) * sizeof (char *));

    for (int i = 0; i < $1; i++) {
	VALUE v = rb_obj_as_string(RARRAY($input)->ptr[i]);
	$2[i] = RSTRING(v)->ptr;
    }
}

%typemap(freearg) (int argc, char **argv) {
    free ((char *) $2);
}

void init_env (int argc, char **argv);

%extend Simulator {
    void add_task_proc (VALUE cb, unsigned int millis) {
	self->RaiseEvent (new refcounted<SpEvent> (cb), SID_NONE, millis);
    }
}

%{
/* 
 * Manually wrapped since we want to parse the associated block 
 * and I could not find any SWIG-declaration to do it.
 */
static VALUE
_manually_wrapped_add_task (int argc, VALUE *argv, VALUE self) {
    Simulator *sim = (Simulator *) 0 ;
    VALUE millis;
    VALUE block;

    if (argc != 1) 
	rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);

    /* convert first argument to a pointer to a Simulator object */
    SWIG_ConvertPtr(self, (void **) &sim, SWIGTYPE_p_Simulator, 0);
    /* parse the arguments. 1 -> 1 mandatory argument, & -> parse a
     * corresponding block */
    rb_scan_args (argc, argv, "1&", &millis, &block);

    sim->RaiseEvent (new refcounted<SpEvent> (block), SID_NONE, NUM2INT(millis));

    return Qnil;
}
%}  

%init %{
    rb_define_method(cSimulator.klass, "add_task", VALUEFUNC(_manually_wrapped_add_task), -1);
%}

class MercuryNode : public Node {
public:
    MercuryNode(NetworkLayer *network, Scheduler *scheduler, IPEndPoint& addr);

    // otherwise swig wouldn't instantiate Mercurynode
    void ReceiveMessage (IPEndPoint *from, Message *msg);
    
    uint32 GetIP() { return m_Address.GetIP(); }
    uint16 GetPort() { return m_Address.GetPort(); }

    void Stop ();

    void SendEvent (Event *pub);
    void RegisterInterest (Interest *sub);

    void RegisterApplication (Application *app);

    HubManager *GetHubManager() { return m_HubManager; }
    Application *GetApplication () { return m_Application; }

    std::vector<Constraint> GetHubConstraints ();
    std::vector<Neighbor> GetSuccessors (int hubid);
    std::vector<Neighbor> GetPredecessors (int hubid);
    std::vector<Neighbor> GetLongNeighbors (int hubid);
    std::vector<Constraint> GetHubRanges ();
};

%apply SWIGTYPE *DISOWN {DummyApp *app};
class SimMercuryNode : public MercuryNode {
public:
    SimMercuryNode(NetworkLayer *network, Scheduler *sched, IPEndPoint& addr);
    void StartUp();    
};

%extend SimMercuryNode { 
    void RegisterDummyApp (DummyApp *app) { 
	self->RegisterApplication ((Application *) app);
    }
}
%clear DummyApp *app;

// vim: set filetype=cpp:
