/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#ifndef __VPACKET__H
#define __VPACKET__H

#include <async.h>
#include <util/Packet.h>

struct MercMessage;

/**
 * Only used for shipping data (write once, read once)
 */
class VPacket : public Packet {
private:
    ref<suio> uio;
public:

    VPacket();
    VPacket(MercMessage *msg);
    virtual ~VPacket();

    /** only valid when entire packet written/before any read */ 
    virtual uint32 GetSize() { return uio->resid(); }

    virtual void WriteBuffer(byte *buf, int len);
    virtual void ReadBuffer(byte *buf, int len);

    virtual void WriteByte(byte b); 
    virtual byte ReadByte();
    virtual byte PeekByte();

    virtual void WriteBool (bool b);
    virtual bool ReadBool ();

    virtual void WriteShort(uint16 s);
    virtual uint16 ReadShort();

    virtual void WriteInt(uint32 i);
    virtual uint32 ReadInt();

    virtual void WriteIntNoSwap(uint32 i);
    virtual uint32 ReadIntNoSwap();

    virtual void WriteFloat(float f);
    virtual float ReadFloat();

    virtual void WriteString(string& s);
    virtual void ReadString(string& s);

    //virtual void WriteBlob(size_t len, void *data);
    //virtual size_t ReadBlob(void *data);

    ref<suio> GetBuffer() { return uio; }
};

#endif // __VPACKET__H
