/* vim: set sw=4 ts=4 noet: -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

#include <awan-env/VPacket.h>
#include <mercury/MercMessage.h>
#include <cstdlib>

VPacket::VPacket() : uio(New refcounted<suio>()), Packet(NULL, false)
{
}

VPacket::VPacket(MercMessage * msg) : uio(New refcounted<suio>()), Packet(NULL, false)
{
	msg->Serialize(this);
}

VPacket::~VPacket()
{
}

void VPacket::WriteBuffer(byte * buf, int len)
{
	uio->copy(buf, len);
}

void VPacket::ReadBuffer(byte * buf, int len)
{
	ASSERT(uio->resid() >= (uint32)len);
	uio->copyout(buf, len);
	uio->rembytes(len);
}

void VPacket::WriteByte(byte b)
{
	DB(40) << "." << endl;
	uio->copy(&b, 1);
}

byte VPacket::ReadByte()
{
	DB(40) << "." << endl;
	byte ret;
	ASSERT(uio->resid() >= 1);
	uio->copyout((void *)&ret, 1);
	uio->rembytes(1);
	return ret;
}

// Dont increment m_BufPosition
byte VPacket::PeekByte()
{
	DB(40) << "." << endl;
	byte ret;
	ASSERT(uio->resid() >= 1);
	uio->copyout((void *)&ret, 1);
	return ret;
}

void VPacket::WriteBool(bool b)
{
	DB(40) << "." << endl;
	WriteByte (b ? 0x1 : 0x0);
}

bool VPacket::ReadBool()
{
	DB(40) << "." << endl;
	byte b = ReadByte ();
	if (b == 0x0) 
		return false;
	return true;
}

void VPacket::WriteShort(uint16 s)
{
	DB(40) << "." << endl;
	uint16 ns = htons(s);
	uio->copy(&ns, 2);
}

uint16 VPacket::ReadShort()
{
	DB(40) << "." << endl;
	uint16 ret;
	ASSERT(uio->resid() >= 2);
	uio->copyout((void *)&ret, 2);
	uio->rembytes(2);
	return ntohs(ret);
}

void VPacket::WriteInt(uint32 i)
{
	DB(40) << "." << endl;
	uint32 nl = htonl(i);
	uio->copy(&nl, 4);
}

uint32 VPacket::ReadInt()
{
	DB(40) << "." << endl;
	uint32 ret;
	ASSERT(uio->resid() >= 4);
	uio->copyout((void *)&ret, 4);
	uio->rembytes(4);
	return ntohl(ret);
}

void VPacket::WriteIntNoSwap(uint32 i)
{
	DB(40) << "." << endl;
	uio->copy(&i, 4);
}

uint32 VPacket::ReadIntNoSwap()
{
	DB(40) << "." << endl;
	uint32 ret;
	ASSERT(uio->resid() >= 4);
	uio->copyout((void *)&ret, 4);
	uio->rembytes(4);
	return ret;
}

void VPacket::WriteFloat(float f)
{
	DB(40) << "." << endl;
	union {
		float _f;
		uint32 _i;
	} dat;
	dat._f = f;
	WriteInt(dat._i);
}

float VPacket::ReadFloat()
{
	DB(40) << "." << endl;
	union {
		float _f;
		uint32 _i;
	} dat;
	dat._i = ReadInt();
	return dat._f;
}

void VPacket::WriteString(string & s)
{
	DB(40) << "." << endl;
	WriteInt(s.length());
	WriteBuffer((byte *) s.c_str(), s.length());
}

void VPacket::ReadString(string & s)
{
	DB(40) << "." << endl;
	int strLen = (int) ReadInt();

	// xxx yuck!
	char *b = new char[strLen];
	ReadBuffer((byte *)b, strLen);
	s = string(b, strLen);
	delete b;
}
