/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#ifndef __PREPACKET__H
#define __PREPACKET__H

#include <util/Packet.h>
#include <util/dbfe.h>

struct MercMessage;

/**
 * Used when we want to serialize into a preallocated buffer
 */
class PrePacket : public Packet {
public:    
    PrePacket(byte *buf, uint32 len) : Packet(NULL, false) {
	m_Buffer = buf;
	m_BufPosition = 0;
	m_Size = len;
	m_Used = 0;
    }
    PrePacket(dbrec *rec) : Packet(NULL, false) {
	m_Buffer = (byte *)rec->value;
	m_BufPosition = 0;
	m_Size = rec->len;
	m_Used = 0;
    }
    virtual ~PrePacket() {
	m_Buffer = NULL;
    }
};

#endif // __PREPACKET__H
