/* vim: set sw=4 ts=4 noet: -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

#ifndef __BARRIER_H__
#define __BARRIER_H__

#include <async.h>
#include <awan-env/ARealNet.h>

class Barrier {
private:
	ARealNet *net;
	bool isMaster;
	bool isDone;
	callback<void,void>::ptr waitcb;
	timecb_t *signal_repeater;
	IPEndPoint master;
	uint32 nonce;
	uint32 count;
	SIDSet done;

	void SendSignal();
	void ProcessSignal(const IPEndPoint& from);
	void ProcessMessage(ConnStatusType t,IPEndPoint from,MercMessage *msg);
public:
	Barrier(const IPEndPoint& master, 
			const IPEndPoint& me,
			uint32 nonce, uint32 count);
	~Barrier();

	void signal();
	void wait(callback<void,void>::ref cb);
};

#endif
