/* vim: set sw=4 ts=4 noet: -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

#ifndef __ASYNC_UTIL_H__
#define __ASYNC_UTIL_H__

//
// Extensions to libasync
//

#include <async.h>
#include <util/types.h>

struct fdcb_t;
class MercuryNodeInterface;

/**
 * Register a fd callback that will be called exactly once. Returns
 * a token that can be used to unregister the cb before it executes.
 * (token becomes invalid after cb executes!). You can register
 * multiple callbacks on this fd using this function, but you can
 * not mix it with fdcb() in libasync.
 */
fdcb_t *fdcb_once(int socket, selop operation, callback<void>::ref cb);
/**
 * Remove a fd callback registered with fdcb_once.
 */
void fdcb_once_remove(fdcb_t *k);

static const uint32 MERCURY_DOWORK_INTERVAL = 50; // ms

void amerc_init(MercuryNodeInterface *node);

#endif
