/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#ifndef __AUNBUFFERED_CONNECTION__H
#define __AUNBUFFERED_CONNECTION__H

#include <util/debug.h>
#include <awan-env/AConnection.h>
#include <awan-env/VPacket.h>

class AUnbufferedConnection : public AConnection {

protected:

    TimeVal  m_TimeStamp;     // Timestamp on received packet
    VPacket* m_Packet;        // Packet to store incoming bytes

    AUnbufferedConnection(ATransport *t, Socket sock, 
	    IPEndPoint *otherEnd) :
	AConnection(t, sock, otherEnd), 
    m_Packet(0), m_TimeStamp(TIME_NONE) {}
    virtual ~AUnbufferedConnection() {
	if (m_Packet)
	    delete m_Packet;
    }

    void _InitPacket(uint32 len) {
	if (m_Packet) {
	    WARN << "Initializing new packet without reseting it! " 
		<< this << endl;
	    ASSERT(0);
	}
	m_Packet = new VPacket();
    }

    void _ResetPacket() {
	m_Packet = 0;
	m_TimeStamp = TIME_NONE;
    }

    Packet *GetNextPacket(PacketAuxInfo *aux) {
	//DB(1) << "called: " << this << endl;
	aux->timestamp = m_TimeStamp;
	VPacket *ret = m_Packet;
	_ResetPacket();
	return ret;
    }

    void FreePacket(Packet *pkt) {
	delete pkt;
    }
};

#endif // __AUNBUFFERED_CONNECTION__H
