/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#ifndef __AUDP_TRANSPORT__H
#define __AUDP_TRANSPORT__H

#include <awan-env/ATransport.h>
#include <awan-env/AUDPConnection.h>

typedef enum { Q_DROPTAIL, Q_DROPHEAD } QueuingDiscType;

/**
 * Basic interface to kernel level TCP Transport.
 */
class AUDPTransport : public ATransport {

    friend class AUDPConnection;
    list<lazycb_t *> m_LazyCBs;

protected:

    Socket m_ListenSocket;

    /**
     * Construct an appropriate UDP connection (or subclass) for this 
     * transport.
     */
    virtual AUDPConnection *CreateConnection(Socket sock, IPEndPoint *otherEnd);

    /**
     * Add a new connection to all the connection data structures.
     */
    virtual void AddConnection(AConnection *conn);

    /**
     * Remove a stale connection from all the connection data structures.
     */
    virtual void RemoveConnection(AConnection *conn);

    void RegisterCBs();
    void UnregisterCBs();

    void ReadyConnectionCB();

public:

    static const QueuingDiscType QUEUING_DISCIPLINE = Q_DROPHEAD;
    /** Max datagram size; set by OS */
    static       int MAX_UDP_MSGSIZE;
    /** MercMessage queue size (per connection), # packets */
    static const int APP_QUEUE_SIZE                 = 1024;
    /** Max number of packets to dequeue from kernel at a time in DoWork() */
    static const int MAX_PKTS_SERVICE               = 1280000;

    AUDPTransport() {}
    virtual ~AUDPTransport() {}

    void  StartListening();
    void  StopListening();

    void GetConnection(IPEndPoint *target, GetConnectionCB::ref cb);
    void CloseConnection(IPEndPoint *target);
};

#endif // __AUDP_TRANSPORT__H
