/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#ifndef __AUDP_CONNECTION__H
#define __AUDP_CONNECTION__H

#include "VPacket.h"
#include "AConnection.h"
#include <list>
#include <util/GPL/refcnt.h>
#include <util/Mutex.h>
//#include "AUDPTransport.h"

struct PacketInfo {
    Packet *pkt;
    TimeVal timestamp;

    PacketInfo(Packet *pkt, const TimeVal& stamp) : 
	pkt(pkt), timestamp(stamp) {}
};

typedef list< ref<PacketInfo> > PacketInfoQueue;

class AUDPConnection : public AConnection {

    friend class AUDPTransport;

    Mutex           m_Lock;
    PacketInfoQueue m_Queue;

protected:

    AUDPConnection(ATransport *t, Socket sock, IPEndPoint *otherEnd);

    void Send(VPacket *tosend, StatusCB::ptr cb);
    Packet *GetNextPacket(PacketAuxInfo *aux);
    void FreePacket(Packet *pkt);

    /*
       int Send(Packet *tosend);
       Packet *GetNextPacket(PacketAuxInfo *aux);
       void FreePacket(Packet *pkt);
     */

    inline void Lock() {}
    inline void Unlock() {}

    int  Size();
    void Insert(Packet *pkt, TimeVal& val);
    ptr<PacketInfo> Pop();

public:

    virtual ~AUDPConnection();
};

#endif // __AUDP_CONNECTION__H
