/* vim: set sw=4 ts=4 noet: -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

#include <awan-env/AUDPConnection.h>
#include <mercury/MercMessage.h>
#include <util/Packet.h>
#include <awan-env/ARealNet.h>
#include "AUDPTransport.h"

int AUDPConnection::Size() {
	Lock();
	int ret = m_Queue.size();
	Unlock();
	return ret;
}

void AUDPConnection::Insert(Packet *pkt, TimeVal& stamp) {
	Lock();
	m_Queue.push_back( New refcounted<PacketInfo>(pkt, stamp) );
	Unlock();
}

ptr<PacketInfo> AUDPConnection::Pop() {
	ptr<PacketInfo> ret = NULL;
	Lock();
	if (m_Queue.size() != 0) {
		ret = m_Queue.front();
		m_Queue.pop_front();
	}
	Unlock();
	return ret;
}

AUDPConnection::AUDPConnection(ATransport *t, Socket sock, IPEndPoint *otherEnd) :
AConnection(t, sock, otherEnd)
{
	SetSocketPeerAddress(otherEnd);
}

AUDPConnection::~AUDPConnection() {
	Lock();
	for (PacketInfoQueue::iterator it = m_Queue.begin();
			it != m_Queue.end(); it++) {
		delete (*it)->pkt;
	}
	Unlock();
}

void AUDPConnection::Send(VPacket *pkt, StatusCB::ptr cb) {
	//ARealNet::Write(GetSocket(), pkt->GetBuffer(), cb);
	ARealNet::WriteDatagram(GetSocket(), *GetAppPeerAddress(),
			pkt->GetBuffer(), cb);
	delete pkt;
}

Packet *AUDPConnection::GetNextPacket(PacketAuxInfo *aux)
{
	ptr<PacketInfo> info = Pop();
	if (info == NULL) {
		bzero(aux, sizeof(PacketAuxInfo));
		return NULL;
	} else {
		DB(20) << " getting a packet from AUDP connection " << endl;
		aux->timestamp = info->timestamp;
		return info->pkt;
	}
}

void AUDPConnection::FreePacket(Packet *pkt)
{
	delete pkt;
}
