/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#ifndef __ATRANSPORT__H
#define __ATRANSPORT__H

#include <map>
#include <async.h>
#include <mercury/common.h>

#include <wan-env/Transport.h>

class ARealNet;
class AConnection;

///////////////////////////////////////////////////////////////////////////////

typedef map<IPEndPoint, AConnection *, less_SID> _aconn_hash_t;
typedef _aconn_hash_t::iterator _aconn_hash_iter;

class AConnectionHash : public _aconn_hash_t {
public:
    AConnection *Lookup(IPEndPoint *otherEnd) {
	_aconn_hash_iter it = find(*otherEnd);
	if (it == end())
	    return 0;
	else
	    return (*it).second;
    }
    void Insert(IPEndPoint *otherEnd, AConnection *conn) {
	insert(value_type(*otherEnd, conn));
    }

    void Flush(IPEndPoint *otherEnd) {
	_aconn_hash_iter it = find(*otherEnd);
	if (it != end())
	    erase(it);
    }
};

typedef AConnectionHash::iterator AConnectionHashIter;

typedef list<AConnection *> AConnectionList;
typedef AConnectionList::iterator AConnectionListIter;

typedef callback<void,AConnection *,int> GetConnectionCB;

class ATransport {

protected:

    ARealNet       *m_Network;
    IPEndPoint     m_ID;
    TransportType  m_Proto;

    // These are for convinience... subclasses need not actually use them
    AConnectionHash m_AppConnHash;    // unique appid -> connection map
    AConnectionList m_ConnectionList; // used as a round-robin recv queue

    // legacy junk
    inline void Lock() {}
    inline void Unlock() {}

    ATransport() {}

public:

    virtual void _ClearConnections();
    virtual void _CleanupConnections();
    void _PrintConnections();
    void _PrintConnHash();

    /**
     * All ATransport instances must be created from this funcion.
     */
    static ATransport *Create(ARealNet *net, 
	    TransportType protocol, 
	    IPEndPoint id);

    /**
     * Lookup a protocol ID by some variant of its string name.
     */
    static TransportType GetProtoByName(const char *proto_name);

    virtual ~ATransport() {}

    /**
     * Get the creating network layer.
     */
    ARealNet *GetNetwork() { return m_Network; }

    /**
     * Get the the protocol
     */
    TransportType GetProtocol() { return m_Proto; }

    /**
     * Get this end's app id
     */
    IPEndPoint GetAppID() { return m_ID; }

    /** 
     * Begin the listening for the protocol
     */
    virtual void  StartListening() = 0;

    /** 
     * Stop listening 
     */
    virtual void  StopListening() = 0;

    /** 
     * Get a (possibly new) connection to a target endpoint. 
     * Returns NULL if we can't connect to the target.
     */
    virtual void GetConnection(IPEndPoint *target, GetConnectionCB::ref cb) = 0;

    /** 
     * Close a connection. This explicit close will NOT generate
     * a CONN_CLOSED event via GetReadyConnection. This call signals
     * that the connection can be garbage collected.
     */
    virtual void CloseConnection(IPEndPoint *target)              = 0;
};

#endif // __ATRANSPORT__H
