/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#include <util/OS.h>
#include <mercury/options.h>
#include <awan-env/ARealNet.h>
#include <awan-env/ATransport.h>
#include <awan-env/ATCPConnection.h>
#include <awan-env/AUDPTransport.h>
#include <awan-env/ATCPTransport.h>
//#include <awan-env/ATCPPassiveTransport.h>
//#include <awan-env/ACBRTransport.h>

ATransport *ATransport::Create(ARealNet *net, TransportType protocol, IPEndPoint id) {
    ATransport *ret = 0;

    switch (protocol) {
    case PROTO_UDP:
	ret = new AUDPTransport();
	break;
    case PROTO_TCP:
	ret = new ATCPTransport();
	// Jeff: this is hacky :P
	static_cast<ATCPTransport *>(ret)->SetMaxOpenConnections(g_Preferences.max_tcp_connections);
	break;
    case PROTO_TCP_PASSIVE:
	ASSERT(0);
	//ret = new TCPPassiveTransport();
	break;
    case PROTO_CBR:
	ASSERT(0);
	//ret = new CBRTransport();
	break;

	//
	// Insert Additional Transport constructors here!
	//

    default:
	ASSERT(0);
    }

    ret->m_Network = net;
    ret->m_ID      = id;
    ret->m_Proto   = protocol;

    return ret;
}

#ifndef streq
#define streq(a,b) (!strcmp((a),(b)))
#endif

TransportType ATransport::GetProtoByName(const char *proto_name)
{
    const char *name_part;
    if (!strncmp(proto_name, "PROTO_", strlen("PROTO_"))) {
	name_part = proto_name + strlen("PROTO_");
    } else {
	name_part = proto_name;
    }

    if (streq(name_part, "UDP")) {
	return PROTO_UDP;
    } else if (streq(name_part, "TCP")) {
	return PROTO_TCP;
    } else if (streq(name_part, "TCP_PASSIVE")) {
	return PROTO_TCP_PASSIVE;
    } else if (streq(name_part, "CBR")) {
	return PROTO_CBR;
    } else {
	WARN << "unknown protocol name: " << proto_name << " ("
	    << name_part << ")" << endl;
	ASSERT(0);
    }

    return PROTO_INVALID;
}

void ATransport::_ClearConnections() {
    Lock();

    for (AConnectionListIter iter = m_ConnectionList.begin(); 
	    iter != m_ConnectionList.end(); iter++) {
	AConnection *connection = (*iter);
	if (connection) {
	    DB(1) << "deleting connection to: " 
		<< connection->GetAppPeerAddress() << endl;
	    if (connection->GetSocket() >= 0)
		fdcb(connection->GetSocket(), selread, NULL);
	    OS::CloseSocket( connection->GetSocket() );
	    connection->SetStatus(CONN_CLOSED);
	    delete connection;
	}
    }
    m_ConnectionList.clear();
    m_AppConnHash.clear();

    Unlock();
}

//
// get rid of connections which were closed by us or the other side
//
void ATransport::_CleanupConnections() {
    Lock();

    DBG << "cleaning up connections..." << endl;

    for (AConnectionListIter iter = m_ConnectionList.begin(); 
	    iter != m_ConnectionList.end(); /* WATCH OUT! */ ) {
	AConnection *connection = (*iter);
	if (connection->GetStatus() == CONN_CLOSED ||
		connection->GetStatus() == CONN_ERROR) {
	    DB(1) << "Deleting connection: " << connection << endl;

	    if (connection->GetSocket() >= 0)
		fdcb(connection->GetSocket(), selread, NULL);
	    IPEndPoint *peer = connection->GetAppPeerAddress();
	    m_AppConnHash.Flush(peer);

	    // Can't rely on 'iter' being a valid "next" iterator 
	    // after the erase operation.
	    AConnectionListIter oiter = iter;
	    oiter++;
	    m_ConnectionList.erase(iter);
	    delete connection;

	    iter = oiter;
	}
	else {
	    DBG << "ok: " << connection << endl;
	    DBG << "readable (" << connection->GetSocket() << "): " << ARealNet::IsDataWaiting(connection->GetSocket()) << endl;
	    iter++;
	}
    }

    Unlock();
}

///////////////////////////////////////////////////////////////////////////////

void ATransport::_PrintConnections()
{
    int i = 1;
    for (AConnectionListIter iter = m_ConnectionList.begin();
	    iter != m_ConnectionList.end(); iter++) {
	AConnection *connection = (*iter);

	DB(1) << "Connection #" << i++ << ": \tapp="
	    << connection->GetAppPeerAddress()->ToString() << endl;
	DB(1) << " sock:" << connection->GetSocketPeerAddress()->ToString()
	    << " status:" << g_ConnStatusStrings[connection->GetStatus()]
	    << endl;
    }
}

void ATransport::_PrintConnHash()
{
    int i = 0;
    DB(1) << "<<<<< HASH >>>>>\n";
    for (AConnectionHashIter iter = m_AppConnHash.begin();
	    iter != m_AppConnHash.end(); iter++) {
	AConnection *connection = (*iter).second;

	DB(1) << "Connection key: <" << (*iter).first.ToString() << "> " 
	    << endl;
	DB(1) << "\tapp="
	    << connection->GetAppPeerAddress()->ToString() << endl;
	DB(1) << " sock:" << connection->GetSocketPeerAddress()->ToString()
	    << " status:" << g_ConnStatusStrings[connection->GetStatus()]
	    << endl;
    }
    DB(1) << "-------------------\n";
}
