/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#ifndef __ATCP_TRANSPORT__H
#define __ATCP_TRANSPORT__H

#include <awan-env/ARealNet.h>
#include <awan-env/ATransport.h>
#include <awan-env/ATCPConnection.h>

typedef map<IPEndPoint, list<GetConnectionCB::ref> *, less_SID> PendingConnectMap;
typedef PendingConnectMap::iterator PendingConnectMapIter;

struct _tcp_addr {
    byte buf[4+2];

    _tcp_addr() {}
    _tcp_addr(const IPEndPoint& e) {
	from(e);
    }

    void from(const IPEndPoint& e) {
	from(e.GetIP(), e.GetPort());
    }
    void from(uint32 ip, uint16 port) {
	uint16 nport = htons(port);
	memcpy(buf, (byte *)&ip, 4);
	memcpy(buf+4, (byte *)&nport, 2); 
    }

    void to(IPEndPoint& e) {
	to(e.m_IP, e.m_Port);
    }

    void to(uint32& ip, uint16& port) {
	uint16 nport;
	memcpy((byte *)&ip, buf, 4);
	memcpy((byte *)&nport, buf+4, 2);
	port = ntohs(nport);
    }
};

/**
 * Basic interface to kernel level TCP Transport.
 */
class ATCPTransport : public ATransport {

    friend class ATCPConnection;

private:

    uint32 m_MaxOpenConnections;
    // callbacks waiting for a connection attempt to complete
    PendingConnectMap m_PendingConnects;
    list<lazycb_t *> m_LazyCBs;

protected:

    void RegisterCBs();
    void UnregisterCBs();

    Socket m_ListenSocket;

    void DoConnect(IPEndPoint otherEnd, bool init = true,
	    int maxTrials = 20, Socket sock = -1);
    void DoConnectCB(IPEndPoint otherEnd, Socket sock, int err);
    void DoConnectReturnCB(IPEndPoint otherEnd,
	    AConnection *conn, int err);

    void RegisterNewTCPConnectionCB();
    void RegisterNewTCPConnectionCB2(Socket sock,_tcp_addr *addr,int ret);

    void ReadyConnectionCB(ATCPConnection *conn);
    void ReadCompleteCB(ATCPConnection *connection, int status);

    void ActiveCloseConnection(ATCPConnection *connection);
    void ActiveCloseConnectionCB(ATCPConnection *connection);
    void PassiveCloseConnection(ATCPConnection *connection);

public:

    static const int MAX_PENDING_REQUESTS = 50;
    static const int MAX_CONNECT_TRIALS   = 20;
    static const int CONNECT_SLEEP_TIME   = 500;   //  milliseconds
    static const int MAX_TCP_MSGSIZE      = 512*1024; // bytes

    ATCPTransport() : m_MaxOpenConnections(0 /* inf */) {}
    virtual ~ATCPTransport() {}

    void  StartListening();
    void  StopListening();

    void SetMaxOpenConnections(uint32 num) { m_MaxOpenConnections = num; }

    void GetConnection(IPEndPoint *target, GetConnectionCB::ref cb);
    // ungraceful close of connection -- outstanding data is lost
    void CloseConnection(IPEndPoint *target);
    void CloseConnection(AConnection *connection);
};

#endif
