/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#ifndef __ATCP_CONNECTION__H
#define __ATCP_CONNECTION__H

#include <list>
#include <util/Packet.h>

#include <awan-env/ANetUtils.h>
#include <awan-env/AUnbufferedConnection.h>

class ARealNet;
class ATCPTransport;

class ATCPConnection : public AUnbufferedConnection {
private:
    friend class ATCPTransport;

    TimeVal m_LastAccess;

    bool m_IsPendingSend;
    list< pair<VPacket *, StatusCB::ptr> > m_PendingSends;

    // true if this connection is marked for closure
    // no new data should be sent on a closing connection
    bool m_PendingClose;
    // true if we are waiting for the other end to close the connection
    // we should remain in CLOSING state until we get an EOF from the
    // other end even if we have closed our end
    bool m_WaitingClose;

    void SendCB(StatusCB::ptr cb, int status);
    void PerformReadCB1(uint32 *len, StatusCB::ptr cb, int status);
    void PerformReadCB2(uint32 len, StatusCB::ptr cb, int status);

protected:

    ATCPConnection(ATransport *t, Socket sock, IPEndPoint *otherEnd);

    // send a packet and callback when it is complete
    void Send(VPacket *tofill, StatusCB::ptr cb);

    // called by transport when data is waiting. the status cb will be
    // called when an entire packet is read. note: the connection will
    // take over the read callback on this socket when this is called
    void PerformRead(StatusCB::ptr cb);

    void DoClose();
    void FinClose();
    void Close(bool waiting);

    const TimeVal& GetLastAccess() { return m_LastAccess; }

public:

    virtual ~ATCPConnection();
};

#endif // __ATCP_CONNECTION__H
