/* vim: set sw=4 ts=4 noet: -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

#include <mercury/common.h>
#include <util/IPEndPoint.h>
#include <mercury/MercMessage.h>
#include <awan-env/VPacket.h>
#include <awan-env/ATransport.h>
#include <awan-env/AConnection.h>
#include <awan-env/ARealNet.h>

AConnection::AConnection(ATransport *t, Socket sock, IPEndPoint *otherEnd) :
m_Transport(t), m_Socket(sock), m_Status(CONN_OK),
m_AppPeerAddress((uint32)0, 0), m_SocketPeerAddress((uint32)0, 0)
{
	ASSERT(m_Transport);
	//ASSERT(sock > 0);
	ASSERT(otherEnd);
	m_AppPeerAddress = *otherEnd;
	m_Nonce = CreateNonce();
}

AConnection::~AConnection() {}

void AConnection::SetSocketPeerAddress() {
	struct sockaddr_in addr;
	int addrlen = sizeof(sockaddr_in);

	if (getpeername(m_Socket, (struct sockaddr *) &addr, 
				(socklen_t *) &addrlen) < 0) {
		WARN << "AConnection::SetOtherEndAddress(): "
			<< "error in getting peer name for socket." << endl;
	} else {
		m_SocketPeerAddress = IPEndPoint(addr.sin_addr.s_addr, addr.sin_port);
	}
}

int AConnection::GetProtocol() {
	return m_Transport->GetProtocol();
}

void AConnection::SendMessage(VPacket *pkt, StatusCB::ptr cb)
{
	Send(pkt, cb); // delegate to subclass
}

//
// Deserialize the latest complete packet we read and return the message.
// This routine will be called only when we tell the RealNet class that
// we read a complete message. (i.e., when we get a ready connection
// that has data on it.)
//
MercMessage *AConnection::GetLatestMessage() {
	PacketAuxInfo info;
	Packet *pkt = GetNextPacket(&info); // delegate to subclass
	if (pkt) {
		pkt->ResetBufPosition();
		MercMessage *msg = CreateObject<MercMessage>(pkt);
		msg->recvTime = info.timestamp;

		FreePacket(pkt); // delegate to subclass

		return msg;
	} else {
		return NULL;
	}
}

void AConnection::Print(FILE * stream)
{
	fprintf(stream, "[%s] app:%s status:%s\n", 
			g_TransportProtoStrings[GetProtocol()],
			m_AppPeerAddress.ToString(), g_ConnStatusStrings[m_Status]);
}

ostream& operator<<(ostream& out, AConnection *con)
{
	out << "[" << g_TransportProtoStrings[con->GetProtocol()] 
		<< "] uniq_id: " << con->m_Nonce 
		<< " app:" << con->m_AppPeerAddress.ToString() 
		<< " status:" << g_ConnStatusStrings[con->m_Status];
	return out;
}
