#!/usr/bin/perl
use strict;

our $PRINT_ONLY = 0;

my $cmd = "./simd --norand --nodes %d --arrive-int 100 --time %d -v -5 --load-balance --load-balance-delta 2 --sampling --selfhistos --schema test.cfg";
$cmd .= " --spikes %d --spike-height %d";

my $topdir = "log-spike";

foreach my $nodes (100) # (100, 200, 500)
{
    foreach my $spikes (5, 1)
    {
        foreach my $spike_height (1000, 4000, 10000)
        {
            my $time = $nodes / 10 + 100;
            my $odir = "$topdir/nodes-$nodes/spikes-$spikes/maxload-$spike_height";

            psystem ("mkdir -p $odir");

            my $fcmd = sprintf ($cmd, $nodes, $time, $spikes, $spike_height);
	    $fcmd .= " 2>$odir/error.log >$odir/output.log";
            psystem ($fcmd);
        }
    }
}

sub psystem {
    my $cmd = shift;
    print STDERR $cmd, "\n";
    return if $PRINT_ONLY;
    return system ($cmd);
}

