#!/usr/bin/perl
use strict;
use Getopt::Std;
use vars qw($opt_v);

getopts ("v:");
our $VERBOSITY = defined $opt_v ? $opt_v : -1;

my $cmd = "./simd -v $VERBOSITY --arrive-int 100 --histograms --buckets 100 --schema test.cfg " .
       " --fanoutpubs --time %d --nodes ";
foreach my $n (@ARGV) {
    my $final = sprintf ($cmd, int ($n/10) + 20);
    $final .= " $n 2>out.$n | tee /home/mercury/hops.$n ";

    system ($final);
}
