#!/usr/bin/perl

BEGIN {
    $ENV{'TRAVERTINE_PRINTCMDS'} = 1;
}

use strict;
use Travertine;

our $conf = "/tmp/mercury.cnf";
our $cmd = "./simd --nosleep --norand --nodes 100 --arrive-int 100 --time 60 -v -11 --load-balance --load-balance-delta 2 --sampling --selfhistos --schema test.cfg --spikes 5 --spike-height 2000  ";
sub RunCmd {
    my ($cmd, $dir) = @_;

    Travertine::psystem ("mkdir -p $dir");
    $cmd .= " --rconfig $conf >$dir/out 2>&1";
    
    Travertine::psystem ($cmd);
    Travertine::psystem ("mv core.* $dir/");
    my $lastfew = `tail -100 $dir/out | grep Exiting`;
    if ($lastfew eq '') {
	return "OK";
    }
    else {
	return "FAIL";
    }
}

our @params = ( [ 'SuccessorMaintenanceTimeout',  300, 400, 500, 600  ] ,
	[ 'LocalSamplingInterval',  300, 500, 700  ],
	[ 'RandomWalkInterval',   300, 500, 700  ],
	[ 'LeaveJoinResponseTimeout',  1000, 3000, 5000  ]
	);


sub GenerateCombinations {
    my $aref = shift;
    
    my $vconf = shift @$aref;
    my @ret = ();
    my @rec_ret = ("");
    
    if (scalar @$aref > 0) {
	@rec_ret = GenerateCombinations ($aref);
    }

    my $vname = shift @$vconf; 

    foreach my $value (@$vconf) {
	foreach my $e (@rec_ret) { 
	    push @ret, "$vname $value\n$e";
	}
    }
    return @ret;
}

my $dir = 1;
foreach my $combo (GenerateCombinations (\@params))
{
    open F, "> /tmp/mercury.cnf" or die $!;
    print F "$combo";
    Travertine::tinfo ("$combo");
    close F;

    my $result = RunCmd($cmd, "params/$dir");
    print STDERR $result, "\n";

    $dir++;
}
