#!/usr/bin/perl
#
# Simple regression test.
#
# (3) Test interest graph after migration.

use strict;
require "TestLib.pl";

my $NUM_NODES = 5;
my $RANGE = 100;
my $OBJS_PER_NODE = 3;
my $AOE = 1000; #2*$RANGE/$OBJS_PER_NODE;

start_bootstrap( "x" => [0, $RANGE] );

my %node = start_nodes($NUM_NODES, 
		       { "REPLICA_MAINTAIN_TTL" => 10000,
			 "INTEREST_LINK_TTL" => 10000,
			 "REPLICA_INTEREST_TTL" => 10000 },
		       "-l", 30000, "-v", 0, 
		       "-D", "PubSubManager,PubsubRouter,Manager", 
		       "-f", 
		       "--merctrans", "UDP",
		       "--pubtriggers",
		       "--measurement",
		       "--log-flush-interval", 10,
		       "-N", "x", "-A", "name,nickname,ptr,self");

my (@guid, %store, $primary, $replica, $temp);

sub dump_store($) {
    my %store   = store(shift @_);
    foreach my $k (keys %store) {
	print "$k => " . obj_to_str( $store{$k} ) . "\n";
    }
}

info("##### TEST 3: Interest Graph After Migration");

## Set up GUID array
my %guid;
for (my $i=1; $i<=$NUM_NODES; $i++) {
    $guid{$i} = [];
}

## Set up GUID array
my %guid;
my %info;
my %map;
for (my $i=1; $i<=$NUM_NODES; $i++) {
    $guid{$i} = [];
    $info{$i} = [];
}

## Add Objects to each node
for (my $i=1; $i<=$NUM_NODES; $i++) {
    for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
	$guid{$i}->[$j] = add($node{$i});

	$info{$i}->[$j] = {};
	$map{$guid{$i}->[$j]} = $info{$i}->[$j];
	
	$info{$i}->[$j]->{x} = int(rand($RANGE));
	
	$info{$i}->[$j]->{minx} = 
	    max(0, $info{$i}->[$j]->{x} - $AOE/2);
	$info{$i}->[$j]->{maxx} = 
	    min($RANGE, $info{$i}->[$j]->{x} + $AOE/2);

	set($node{$i}, $guid{$i}->[$j], "x", "f:" . $info{$i}->[$j]->{x});
	#setin($node{$i}, $guid{$i}->[$j], 
	#      ["x", ">=", "f:" . $info{$i}->[$j]->{minx}], 
	#      ["x", "<=", "f:" . $info{$i}->[$j]->{maxx}]);
    }
}

idle_all(\%node, 4);
merc_idle_all(\%node, $NUM_NODES*2);


for (my $i=1; $i<=$NUM_NODES; $i++) {
    for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
	#set($node{$i}, $guid{$i}->[$j], "x", "f:" . $info{$i}->[$j]->{x});
	setin($node{$i}, $guid{$i}->[$j], 
	      ["x", ">=", "f:" . $info{$i}->[$j]->{minx}], 
	      ["x", "<=", "f:" . $info{$i}->[$j]->{maxx}]);
    }
}

idle_all(\%node, 4);
merc_idle_all(\%node, $NUM_NODES*2);
idle_all(\%node, 8);

#my @graph = graph($node{1});
#my %gbs = graph_by_src(@graph); 
#info("interest graph at node 1:\n" . graph_to_str(@graph));

check_igraph();

my %targets;
my $failed = undef;

for (my $i=2; $i<=$NUM_NODES; $i++) {
    for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
	$guid{$i}->[$j];

	my $target = int(rand($NUM_NODES))+1;
	next if ($target == $i);
	
	$targets{$guid{$i}->[$j]} = $target;
	migrate($node{$i}, $guid{$i}->[$j], $node{$target}->{sid});
    }
}
idle_all(\%node, 4);

foreach my $guid (keys %targets) {
    my $obj = show($node{$targets{$guid}}, $guid);
    if (!$obj || $obj->{replica}) {
	error("node $targets{$guid} missing object that migrated there! $guid");
	$failed = 1;
    }
}
if ($failed) {
    fail();
}

idle_all(\%node, 4);
merc_idle_all(\%node, $NUM_NODES*2);
idle_all(\%node, 4);
merc_idle_all(\%node, $NUM_NODES*2);
idle_all(\%node, 4);

check_igraph();

sub check_igraph() {

    %store = store($node{1});
    dump_store($node{1});
    my @graph = graph($node{1});
    my %gbs = graph_by_src(@graph); 
    info("interest graph at node 1:\n" . graph_to_str(@graph));
    
    foreach my $guid (keys %store) {
	if ($store{$guid}->{replica}) { next; }
	my $info = $map{$guid};
	my $targets = $gbs{$guid};
	
	for (my $i=1; $i<=$NUM_NODES; $i++) {
	    for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
		next if $guid{$i}->[$j] eq $guid;
		
		if ($info{$i}->[$j]->{x} >= $info->{minx} &&
		    $info{$i}->[$j]->{x} <= $info->{maxx}) {
		    
		    if (! exists $targets->{$guid{$i}->[$j]}) {
			error("$guid not interested in " . $guid{$i}->[$j] .
			      " but should be: x=" . $info{$i}->[$j]->{x} .
			      " range=[" . $info->{minx} . "," . 
			      $info->{maxx} . "]");
			$failed = 1;
		    }
		    
		} else {
		    
		    if (exists $targets->{$guid{$i}->[$j]}) {
			error("$guid interested in " . $guid{$i}->[$j] .
			      " but should not be: x=" . $info{$i}->[$j]->{x} .
			      " range=[" . $info->{minx} . "," . 
			      $info->{maxx} . "]");
			$failed = 1;
		    }
		    
		}
	    }
	}
    }
    
    if ($failed) {
	fail();
    }

}

stop_all();
info("SUCCESS");
