#!/usr/bin/perl
#
# Test Displaying the Interest Graph
#

use strict;
require "TestLib.pl";

my $NUM_NODES = 5;
my $OBJS_PER_NODE = 3;

start_bootstrap( "x" => ["float", 0, 10000] );

my %node = start_nodes($NUM_NODES, 
		       { "REPLICA_MAINTAIN_TTL" => 10000,
			 "INTEREST_LINK_TTL" => 10000,
			 "REPLICA_INTEREST_TTL" => 10000 },
		       "-l", 15000, "-v", 5, "-P", "-f");

sub dump_store($) {
    my %store   = store(shift @_);
    foreach my $k (keys %store) {
	print "$k => " . obj_to_str( $store{$k} ) . "\n";
    }
}

## Set up GUID array
my %guid;
for (my $i=1; $i<=$NUM_NODES; $i++) {
    $guid{$i} = [];
}

## Add Objects to each node
for (my $i=1; $i<=$NUM_NODES; $i++) {
    for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
	$guid{$i}->[$j] = add($node{$i});
    }
}

set($node{1}, $guid{1}->[0], "x", "f:10");
set($node{1}, $guid{1}->[1], "x", "f:15");
set($node{1}, $guid{1}->[2], "x", "f:20");
setin($node{1}, $guid{1}->[0], ["x", ">", "f:0"], ["x", "<", "f:18"]);
setin($node{1}, $guid{1}->[1], ["x", ">", "f:0"], ["x", "<", "f:30"]);
setin($node{1}, $guid{1}->[2], ["x", ">", "f:18"], ["x", "<", "f:22"]);

for (my $i=2; $i<=$NUM_NODES; $i++) {
    for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
	set($node{$i}, $guid{$i}->[$j], "x", "f:" . (10+$j*5));
    }
}

#idle_all(\%node, $NUM_NODES+3);

sleep(5);

dump_graph($node{1});

stop_all();
info("SUCCESS");
