#!/usr/bin/perl
#
# Simple regression test.
#
# (1) Test primary deletion.
# (2) Test forwarding pointers.
# (3) Test interest graph.
#
# XXX TODO: deletion of an object while it is begin resolved remotely

use strict;
require "TestLib.pl";

my $NUM_NODES = 20;
my $RANGE = 100;

start_bootstrap( "x" => ["float", 0, $RANGE] );

my %node = start_nodes($NUM_NODES, {}, "-v", -2, 
		       "-l", 100, "-f", "-D", "Manager,Test");

my (@guid, %store, $primary, $replica, $temp);

sub dump_store($) {
    my %store   = store(shift @_);
    foreach my $k (keys %store) {
	print "$k => " . obj_to_str( $store{$k} ) . "\n";
    }
}

info("##### TEST 0: Benchmark");

## Set up GUID array
my %guid;
for (my $i=1; $i<=$NUM_NODES; $i++) {
    $guid{$i} = [];
}

my $OBJS_PER_NODE = 20;
my $AOE = $RANGE/$OBJS_PER_NODE;

## Add Objects to each node
#for (my $i=1; $i<=$NUM_NODES; $i++) {
#    for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
#	$guid{$i}->[$j] = add($node{$i});
#    }
#}

## Set up GUID array
my %guid;
my %info;
for (my $i=1; $i<=$NUM_NODES; $i++) {
    $guid{$i} = [];
    $info{$i} = [];
}

## Add Objects to each node
for (my $i=1; $i<=$NUM_NODES; $i++) {
    for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
	$guid{$i}->[$j] = add($node{$i});

	$info{$i}->[$j] = {};
	
	$info{$i}->[$j]->{x} = sprintf "%.3f", rand($RANGE);
	
	$info{$i}->[$j]->{minx} = 
	    sprintf "%.3f", max(0, $info{$i}->[$j]->{x} - $AOE/2);
	$info{$i}->[$j]->{maxx} = 
	    sprintf "%.3f",  min($RANGE, $info{$i}->[$j]->{x} + $AOE/2);

	set($node{$i}, $guid{$i}->[$j], "x", "f:" . $info{$i}->[$j]->{x});
	setin($node{$i}, $guid{$i}->[$j], 
	      ["x", ">=", "f:" . $info{$i}->[$j]->{minx}], 
	      ["x", "<=", "f:" . $info{$i}->[$j]->{maxx}]);
    }
}

sleep(10);

idle_all(\%node, 50);

foreach my $k (keys %node) {
    info("Benchmark numbers for $k:\n" . benchmark($node{$k}));
}

stop_all();
info("SUCCESS");
