#!/usr/bin/perl
use strict;
use Statistics::Descriptive;
use Getopt::Std;

use vars qw($opt_b);

getopts ("b");

our $basedir;
chomp ($basedir = `dirname $0`);
require "$basedir/Common.pl";

our $LOG_BINARY = defined $opt_b;

###############################################################################

our $TOPDIR = "$basedir/../";
our %MsgTypes = ();

ParseObjectLogsHeader ();
ProcessLogs(@ARGV);

sub ProcessLogs {
	my @files = @_;
	
	foreach my $f (@files) {
		if ($LOG_BINARY) {
			open F, "$basedir/ParseDiscoveryLatLog $f | " or die "cant open pipe from file $f ($!)";
		}
		else {
			open(F, "<$f") || die "can't open $f ($!)";
		}
		my($start, $end);
		while (<F>) {
			chomp $_;
			m/(\d+\.\d+)\t(\d+)\t(\d+)\t([0-9A-F]{8}?)(.*)$/;

			my $time = $1;
			my $type = $2;
			my $hops = $3;
			my $id   = $4;
			my $alias= $5; $alias =~ s/\t//;
			print sprintf("%14.3f %14s %3d %10s %10s\n", $time, $MsgTypes{$type}, $hops, $id, $alias);
		}
		close F;
	}
}

sub ParseObjectLogsHeader() 
{
# XXX This is kinda hacky and could break...
    my $index = 0;

    open(HEADER, "$TOPDIR/../Merc/mercury/ObjectLogs.h") || 
	die "can't open $TOPDIR/../Merc/mercury/ObjectLogs.h";

    my $begun_class = 0;
    my $begun_enum  = 0;

    while (<HEADER>) {
	chomp $_;

	$_ =~ s|//.*||g;

	if ($_ =~ /struct\s+DiscoveryLatEntry/) {
	    $begun_class = 1;
	}
	if ($begun_class && $_ =~ /enum \{/) {
	    $begun_enum = 1;
	    $_ =~ s/enum \{//;
	    }

	    if ($begun_enum) {
		if ($_ =~ /((?:[\w_]+(?:,\s*)?)+)/) {
		    my $names = $1;
		    my @names = split(/,\s*/, $names);
		    map { $MsgTypes{$index} = $_; $index++; } @names;
		}

		if ($_ =~ /\}/) {
		    last;
		}
	}   
	}

	close(HEADER);
    }

