#!/usr/bin/perl

use strict;
use Getopt::Std;
use Statistics::Descriptive;
use vars qw($opt_d);

getopts("d");

our $BASEPORT = 20000;

my $file     = $ARGV[0];
my $nodes    = $ARGV[1];
my $vservers = $ARGV[2];
if (!$nodes || !$vservers) {
    print STDERR "usage: TopologyLatStats.pl <topo_file> <num_nodes> <num_vservers>\n";
    exit 1;
}

my %nodes;
my %physcount;

my $stats = new Statistics::Descriptive::Full();

my $line = 1;
open(F, "<$file") || die $!;
while (<F>) {
    chomp $_;
    if ($_ =~ /^node (\d+) [\w\-_\.]+:(\d+)/ && keys %nodes < $nodes*$vservers) {
	if (($2 - $BASEPORT) < $vservers) {
	    #print "$line: $_\n";
	    $nodes{$1} = 1;
	}
    } elsif ($_ =~ /node (\d+) ([\w\-_\.]+)/) {
	if ($physcount{$2} < $vservers && keys %nodes < $nodes*$vservers) {
	    $nodes{$1} = 1;
	    $physcount{$2}++;
	}
    }
    elsif ($_ =~ /^(\d+),(\d+) ([\d\.]+)$/) {
	my ($from, $to, $lat) = ($1, $2, $3);
	if ($nodes{$from} && $nodes{$to}) {
	    #print "$line: $_\n";
	    $stats->add_data($lat);
	}
    }
    $line++;
}
close(F);

if ($opt_d) {
    print join("\n", $stats->get_data());
    exit 0;
}

print STDERR "nodes: " . (scalar keys %nodes). "\n";

my $mean = sprintf "%.3f", $stats->mean();
my $std = sprintf "%.3f", $stats->standard_deviation();
my $median = sprintf "%.3f", $stats->median();
my $ninetyfifth = sprintf "%.3f", $stats->percentile(95);
my $count = $stats->count();

print "mean=$mean\tstd=$std\tmed=$median\t95%=$ninetyfifth\tcount=$count\n";
