#!/usr/bin/perl
#
# This script takes input and outputs only those lines after SKIPTIME
# seconds and only for LENGTH time after that. The first field should be
# a timestamp. If RESCALE, then rescale the time so that the 
# starttime+skiptime = 0.
#
# If SLOWDOWN is != 1, then we scale all times by 1/SLOWDOWN relative to
# START (which is an absolute time). The other parameters are taken to be
# in scaled *virtual* time, not absolute time.
#
# The times 

use strict;
use Getopt::Std;
use vars qw($opt_S $opt_s $opt_l $opt_r $opt_w $opt_f);

getopts("S:s:l:rw:f:");

our $START    = defined $opt_S ? $opt_S : undef;
our $SKIPTIME = defined $opt_s ? $opt_s : 120;
our $LENGTH   = defined $opt_l ? $opt_l : 600;
our $SLOWDOWN = defined $opt_w ? $opt_w : 1;
our $FIELD = defined $opt_f ? $opt_f : 0;

our $RESCALE  = defined $opt_r;

$SKIPTIME = $SLOWDOWN * $SKIPTIME;
$LENGTH   = $SLOWDOWN * $LENGTH;

my $start = $START;
my $regexp = "(\\d+\\.\\d+)";
for (my $i = 0; $i < $FIELD; $i++) {
    $regexp = "(\\w+\s)" . $regexp;
}

$regexp = "^$regexp";
# print "regexp=$regexp\n";

while (<>) {
    m/$regexp/;

    my $time;
## XXX BIG FUCKING HACK
    if ($FIELD == 1) {
	$time = $2;
    }
    else {
	$time = $1;
    }
    
#    print "time=$time\n";
    
    die "baddy format: $_" if !defined $time;

    $start = $time if (!defined $start);

    next if ($time < $start + $SKIPTIME);
    last if ($time > $start + $SKIPTIME + $LENGTH);

    if ($SLOWDOWN != 1) {
	$time = $start + ($time - $start)/$SLOWDOWN;
# XXX big fucking hack
	if ($FIELD == 1) {
	    $_ =~ s/$regexp/$1 $time/;
	}
	else {
	    $_ =~ s/$regexp/$time/;
	}

#	$fields[$FIELD] = $time;
    }
    
    if ($RESCALE) {
	my $time = $time - ($start + $SKIPTIME);
	
# XXX big fucking hack
	if ($FIELD == 1) {
	    $_ =~ s/$regexp/$1 $time/;
	}
	else {
	    $_ =~ s/$regexp/$time/;
	}
	
#	$fields[$FIELD] = $time - ($start + $SKIPTIME);
    }

    {
	local $" = "\t";
#	print "@fields\n";
	print;
    }
} 
