#!/usr/bin/perl

use strict;
use Statistics::Descriptive;
use Getopt::Std;
use vars qw($opt_f $opt_h $opt_t);

getopts("f:h:t:");

my $HEAD  = $opt_h;
my $TAIL  = $opt_t;
my $FIELD = $opt_f || 2;

my @dirs = @ARGV;

foreach my $d (@dirs) {
    print ( ('=' x 79), "\n" );
    print "Experiment: $d\n";

    my @files = glob("$d/*");

    my $total = 0;
    my $stats = new Statistics::Descriptive::Full();

    my $cmd = "cut -f $FIELD \$f";
    if ($HEAD) {
	$cmd = "$cmd | head -$HEAD";
    }
    if ($TAIL) {
	$cmd = "$cmd | tail -$TAIL";
    }
    open(P, "for f in @files; do $cmd; done |") || die "can't open pipe: $!";
    while (<P>) {
	chomp $_;
	$stats->add_data($_);
	$total += $_;
    }
    close(P);
    
    print "COUNT:      " . $stats->count() . "\n";
    print "TOTAL:      " . $total . "\n";
    print "MEAN:       " . $stats->mean() . "\n";
    print "STDDEV:     " . $stats->standard_deviation() . "\n";
    print "MEDIAN:     " . $stats->median() . "\n";
    print "95%:        " . $stats->percentile(95) . "\n";
    print "5%:         " . $stats->percentile(5) . "\n";
}
