#!/usr/bin/perl
#
# usage: SubscriptionSizeStats.pl <ObjectInterestLogs>

use strict;
use Statistics::Descriptive;

our $sub_area = new Statistics::Descriptive::Full();
our $sub_vol  = new Statistics::Descriptive::Full();
our $sub_x    = new Statistics::Descriptive::Full();
our $sub_y    = new Statistics::Descriptive::Full();
our $sub_z    = new Statistics::Descriptive::Full();

while (<>) {
    chomp $_;
    if ($_ =~ /^([^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)/) {
	my ($time, $frameno, $guid, $type, $orig, $min, $max) =
	    ($1, $2, $3, $4, $5, $6, $7);

	next if $type ne 'p';

	my @min = ($min =~ /([^,]+),([^,]+),([^,]+)/);
	my @max = ($max =~ /([^,]+),([^,]+),([^,]+)/);

	die if !@min || !@max;

	my $area = ($max[0]-$min[0])*($max[1]-$min[1]);
	my $vol  = ($max[0]-$min[0])*($max[1]-$min[1])*($max[2]-$min[2]);
	
	$sub_area->add_data( $area );
	$sub_vol->add_data( $vol );
	$sub_x->add_data($max[0]-$min[0]);
	$sub_y->add_data($max[1]-$min[1]);
	$sub_z->add_data($max[2]-$min[2]);
    } else {
	warn "bad line: $_";
    }
}

print sprintf "%10s %15s %15s %15s %15s %15s\n",
    "name", "mean", "stddev", "median", "5%", "95%";
foreach my $p ( ['sub_area', $sub_area],
		['sub_vol', $sub_vol],
		['sub_x', $sub_x],
		['sub_y', $sub_y],
		['sub_z', $sub_z] ) 
{
    my ($name, $stat) = @$p;

    print sprintf "%10s %15.3f %15.3f %15.3f %15.3f %15.3f\n",
    $name, $stat->mean(), $stat->standard_deviation(), $stat->median(), $stat->percentile(5), $stat->percentile(95);
}
