#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use ResultsConf;

Runall("tseries", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;

    my $bwscript = "$ENV{HOME}/Colyseus/scripts/MessageLogTimeSeries.pl";
    if ($AGGLOGS) {
	$bwscript = "$ENV{HOME}/Colyseus/scripts/AggMsgLogTimeSeries.pl";
    }
    my $pipe = "";
    
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];

	my @dirs = ( "om-bwidth",
		     "merc-bwidth",
		     "routing-bwidth",
		     "matching-bwidth",
		     "total-bwidth",
		     "frame-time",
		     "numreplicas",
		     #"numreplicas-detailed",
		   );

	foreach my $d (@dirs) {
	    system("rm -rf $outdir/$out/$d/$exp");
	    system("mkdir -p $outdir/$out/$d/$exp");
	}
	
	print STDERR "### Expt -- $exp...\n";
	
	my $start    = GetStartTime($dir);
	my $slowdown = GetSlowDown($dir);
	my @files;
	if ($AGGLOGS) {
		@files = glob("$dir/AggregateMessage*");
	} else {
		@files = glob "$dir/Message*";
	}

	chdir $dir;
	foreach my $f (@files) {
	    $f =~ /(\d+\.\d+\.\d+\.\d+\:\d+)/;
	    my $id = $1;
	    die "bad filename $f" if !$id;

	    my $shopts = "-S $start -s $SKIPTIME -l $LENGTH";
	    my $bwopts = "$shopts -e 0.1 -t proto";
	    my $field = 0;

	    $field = 1 if (!$AGGLOGS);
	    
	    if ($slowdown != 1) {
		$pipe = "$ENV{HOME}/Colyseus/scripts/TimeFilter.pl -S $start -w $slowdown -f $field |";		
	    }

	    my $cat = $f =~ /\.gz$/ ? "zcat" : "cat";
	 
	    system ("$cat $f | $pipe $bwscript $bwopts -o /dev/stdin > $outdir/$out/om-bwidth/$exp/$id.log");
	    system ("$cat $f | $pipe $bwscript $bwopts -m /dev/stdin > $outdir/$out/merc-bwidth/$exp/$id.log");
	    system ("$cat $f | $pipe $bwscript $bwopts -r /dev/stdin > $outdir/$out/routing-bwidth/$exp/$id.log");
	    system ("$cat $f | $pipe $bwscript $bwopts -c /dev/stdin > $outdir/$out/matching-bwidth/$exp/$id.log");
	    system ("$cat $f | $pipe $bwscript $bwopts /dev/stdin > $outdir/$out/total-bwidth/$exp/$id.log");
	    
	    #$f = (glob("$dir/QuakeStatsLog.$id.log*"))[0];
	    #die if !$f;
	    #my $cat = $f =~ /\.gz$/ ? "zcat" : "cat";
	    #system("$cat $f | $pipe cut -f1,4 | ~/Colyseus/scripts/TimeFilter.pl $shopts > $outdir/$out/frame-time/$exp/$id.log");

	    #$f = (glob("$dir/ReplicaLifetimeLog.$id.log*"))[0];
	    #die if !$f;
	    #my $cat = $f =~ /\.gz$/ ? "zcat" : "cat";
	    #system("$cat $f | $pipe ~/Colyseus/scripts/ReplicaCountTimeSeries.pl $shopts /dev/stdin > $outdir/$out/numreplicas/$exp/$id.log");
	    #system("cat ReplicaLifetimeLog.$id.log | $pipe ~/Colyseus/scripts/ReplicaCountTimeSeries.pl $shopts -d /dev/stdin > $outdir/$out/numreplicas-detailed/$exp/$id.log");
	}
    }
}
