#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use Getopt::Std;
use vars qw($opt_a);
use ResultsConf;

getopts ("a");
our $APPEND = defined $opt_a;
Runall("latency-detailed", \&DoIt);
Runall("latency", \&DoItLatency);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;
    
    if (!$APPEND) {
	system("rm -rf $outdir/$out");
    }
    system("mkdir -p $outdir/$out");
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];
	
	print STDERR "### Expt -- $exp...\n";

	my $start = GetStartTime($dir);
	my $slowdown = GetSlowDown ($dir);
	my @files = glob "$dir/DiscoveryLat*";
	
	my $cmd;

	$cmd = "$ENV{HOME}/Colyseus/scripts/nsd1 -S $start -s $SKIPTIME -l $LENGTH -o $dir ";
	if ($slowdown > 1.0) { 
	    $cmd .= " -w $slowdown ";
	}
	system ("$cmd @files");
	
	$cmd = "$ENV{HOME}/Colyseus/scripts/NewSubDiscoveryTime2.pl -a $LOGARGS -S $start -s $SKIPTIME -l $LENGTH";
	if ($slowdown > 1.0) { 
	    $cmd .= " -w $slowdown ";
	}
	
	system ("$cmd $dir/aliases.map $dir/discov.log.gz > $outdir/$out/$exp");
	if ($? & 127) { 
	    print STDERR "signal caught. exiting.\n";
	    exit ($?);
	}
    }
}

sub DoItLatency {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;
    
    if (!$APPEND) {
	system("rm -f $outdir/$out");
    }
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];
	
	print STDERR "### Expt -- $exp...\n";
	open(F, ">>$outdir/$out") || die $!;
	print F "Experiment = $exp\n", "="x80, "\n";
	close(F);

	my $start = GetStartTime($dir);
	my $slowdown = GetSlowDown ($dir);
	my @files = glob "$dir/DiscoveryLat*";
	
	my $cmd;

	$cmd = "$ENV{HOME}/Colyseus/scripts/NewSubDiscoveryTime2.pl $LOGARGS -S $start -s $SKIPTIME -l $LENGTH -n ";
	if ($slowdown > 1.0) { 
	    $cmd .= " -w $slowdown ";
	}
	
	system ("$cmd $dir/aliases.map $dir/discov.log.gz >> $outdir/$out");
	if ($? & 127) { 
	    print STDERR "signal caught. exiting.\n";
	    exit ($?);
	}
    }
}
