#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use ResultsConf;

Runall("latency", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;
    
    system("rm -f $outdir/$out");
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];
	
	print STDERR "### Expt -- $exp...\n";
	open(F, ">>$outdir/$out") || die $!;
	print F "Experiment = $exp\n", "="x80, "\n";
	close(F);

	my $start = GetStartTime($dir);
	my $slowdown = GetSlowDown ($dir);
	my @files = glob "$dir/DiscoveryLat*";
	
	my $cmd;

	$cmd = "$ENV{HOME}/Colyseus/scripts/nsd1 -S $start -s $SKIPTIME -l $LENGTH -o $dir ";
	if ($slowdown > 1.0) { 
	    $cmd .= " -w $slowdown ";
	}
	system ("$cmd @files");
	
	$cmd = "$ENV{HOME}/Colyseus/scripts/NewSubDiscoveryTime2.pl $LOGARGS -S $start -s $SKIPTIME -l $LENGTH -n ";
	if ($slowdown > 1.0) { 
	    $cmd .= " -w $slowdown ";
	}
	
	system ("$cmd $dir/aliases.map $dir/discov.log.gz >> $outdir/$out");
	if ($? & 127) { 
	    print STDERR "signal caught. exiting.\n";
	    exit ($?);
	}
    }
}
