#!/usr/bin/perl

use strict;
use Getopt::Std;
use Statistics::Descriptive;
use ResultsConf;
use vars qw($opt_a $opt_n $opt_f);

# -a absolute count rather than fraction
# -n count needed
getopts("anf:");

our $ABSOLUTE = $opt_a;
our $NEEDED   = $opt_n;
our $FUDGE    = defined $opt_f ? $opt_f : 0;

Runall("rep-consistency-detail", \&DoIt);

# XXX ARGH. The ReplicaConsistencyDetailedSummary script is BAD BAD. 
#     it does a sneaky 'use ResultsConf' internally.
#
sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;
    
    my $o = "$outdir/$out.$FUDGE.stats";
    print STDERR "results: $o\n";
    
    foreach my $pair (@expts) {
	my $p   = $pair->[0];
	my $dir = $pair->[1];
	
	my $ext = "$p";
	
	print STDERR "doing $ext...\n";
	
	open(O, ">>$o") or die "can't write to $o";
	print O "$ext\n";
	print O (("=" x 79) . "\n");
	close(O);
	
	system("$ENV{HOME}/Colyseus/scripts/ReplicaConsistencyDetailedSummary.pl $out $p $FUDGE >>$o");
    }
}
