#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use Getopt::Std;
use vars qw($opt_a);
use ResultsConf;

getopts ("a");
our $APPEND = defined $opt_a;
my $OTHER_OPTS = " -d ";
Runall("rep-consistency-detail", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;

    my $script = "repcon"; 
    # my $script = "ReplicaConsistency.pl";
    
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];
	print STDERR "### Expt -- ($dir) $exp...\n";
	
	chdir $dir;

	my $start = GetStartTime($dir);
	my $slowdown = GetSlowDown ($dir);
	my $cmd;

	system("rm -rf $outdir/0/$out/$exp");
	system("mkdir -p $outdir/0/$out/$exp");

	$cmd = "$ENV{HOME}/Colyseus/scripts/$script $OTHER_OPTS -S $start -s $SKIPTIME -l $LENGTH -o $outdir/0/$out/$exp ";
	if ($slowdown > 1.0) {
	    $cmd .= " -w $slowdown ";
	}
	system "$cmd";

	next;

	system("rm -rf $outdir/1/$out/$exp");
	system("mkdir -p $outdir/1/$out/$exp");
	$cmd = "$ENV{HOME}/Colyseus/scripts/$script $OTHER_OPTS -f 1 -S $start -s $SKIPTIME -l $LENGTH -o $outdir/1/$out/$exp ";
	if ($slowdown > 1.0) {
	    $cmd .= " -w $slowdown ";
	}
	system "$cmd";
	
	system("rm -rf $outdir/4/$out/$exp");
	system("mkdir -p $outdir/4/$out/$exp");
	$cmd = "$ENV{HOME}/Colyseus/scripts/$script $OTHER_OPTS -f 4 -S $start -s $SKIPTIME -l $LENGTH -o $outdir/4/$out/$exp" ;
	if ($slowdown > 1.0) {
	    $cmd .= " -w $slowdown ";
	}
	system "$cmd";
    }
}
