#!/usr/bin/perl

use strict;
use Getopt::Std;
use Statistics::Descriptive;
use lib "$ENV{HOME}/Colyseus/scripts";
use ResultsConf;
use vars qw($opt_a $opt_n $opt_f);

# -a absolute count rather than fraction
# -n count needed
getopts("anf:");

our $ABSOLUTE = $opt_a;
our $NEEDED   = $opt_n;
our $FUDGE    = defined $opt_f ? $opt_f : 0;
our @fudges   = defined $opt_f ? ($FUDGE) : (0, 1, 4);

foreach my $f (@fudges) {
    $FUDGE = $f;
    Runall("rep-consistency", \&DoIt);
}

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;

    open (O, ">$outdir/$out.$FUDGE.stats") || die "$outdir/$out.$FUDGE.stats: $!";
    foreach my $pair (@expts) {
	my $p   = $pair->[0];
	my $dir = $pair->[1];

	my $ext = "$p";

	print STDERR "doing $ext...\n";

	print O "$ext\n";
	print O (("=" x 79) . "\n");

	my $f = "$outdir/$FUDGE/$out/$ext";
	die "no such dir $f" if ! -d $f;

	my $stat = Statistics::Descriptive::Full->new();

	foreach my $log (glob("$f/*")) {
	    my $fields;
	    if ($ABSOLUTE) {
		$fields = "2,4";
	    } else {
		$fields = "4,5";
	    }

	    open(D, "cut -f $fields $log |") || die "can't open pipe to $log";
	    while (<D>) {
		chomp $_;
		die "bad line: $_" if $_ !~ /\d/;
		my ($needed, $point);

		if ($ABSOLUTE) {
		    ($point, $needed) = split(/\t/, $_);
		} else {
		    ($needed, $point) = split(/\t/, $_);
		}
		next if $needed == 0;

		if ($NEEDED) {
		    $point = $needed;
		}

		$stat->add_data($point);
	    }
	    close(D);
	}

	if ($stat->count() == 0) {
	    $stat->add_data( 0 );
	}

	my $mean = sprintf "%.5f", $stat->mean();
	my $std  = sprintf "%.5f", $stat->standard_deviation();
	my $med = sprintf "%.5f", $stat->median();
	my $ninefive = sprintf "%.5f", $stat->percentile(95);
	my $ninenine = sprintf "%.5f", $stat->percentile(99);
	my $nineninenine = sprintf "%.5f", $stat->percentile(99.9);

	print O "MEAN\t$mean\n";
	print O "STDDEV\t$std\n";
	print O "MEDIAN\t$med\n";
	print O "95%\t$ninefive\n";
	print O "99%\t$ninenine\n";
	print O "99.9%\t$nineninenine\n";

    }
    close(O);
}
