#!/usr/bin/perl
#
# This runs all the desired "Runall*" scripts in Colyseus/scripts and 
# Colyseus/scripts on a set of machines specified below. It is assumed
# that the results have already been partitioned across the machines
# appropriately so that they have access to what they need.
#
# Colyseus/scripts Colyseus/scripts must be in $ENV{HOME} on all machines.
# You must make sure ALL remote scripts are up to date before running.
# XXX - Figure out why 'cvs update' in the code below doesn't work like
# it fucking should. :P
#

BEGIN {
    # cmu machines are stupid and still use ssh v1
    $ENV{TRAVERTINE_SSHVERSION} = "1,2";
}

use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use lib "$ENV{HOME}/Colyseus/run";
use ResultsConf;
use Travertine;

our $USER = 'jeffpang';

our $SAVEDIR = "$ENV{HOME}/techrep2004-results";

# each entry should be:
#
# hostname => [ logdir, resultdir, [ expts ], { env_variables } ]
our %CONFIG = (

#	       "iris-d-03.cmcl.cs.cmu.edu" => 
#	       [ "/misc/ashu/nsdi2005",
#	       	 "/home/jeffpang/techrep2004/results",
#	       	 [ "nodes" ],
#	       	 { "COL_RESULTS_NODES" => [ 5,10,20,30,40,50 ],
#		   "PERL5LIB" => "/home/jeffpang/Colyseus/scripts/lib:/home/jeffpang/Colyseus/scripts/lib/i686-linux" }],
	       
	       "gs3078.sp.cs.cmu.edu" => 
	       [ "/usr2/jeffpang/techrep2004",
		 "/usr2/jeffpang/techrep2004/results",
		 [ "nodes" ],
		 { "COL_RESULTS_NODES" => [ 5,10,20,30,40,50 ],
		   "PERL5LIB" => "/home/jeffpang/Colyseus/scripts/lib:/home/jeffpang/Colyseus/scripts/lib/i686-linux" } ],
	       
#	       "iris-d-08.cmcl.cs.cmu.edu" =>
#	       [ "/home/jeffpang/techrep2004",
#		 "/home/jeffpang/techrep2004/results",
#		 [ "p2p" ],
#		 { "COL_RESULTS_P2P" => [ 1,3,5,7,8,10,20,30,40,50 ],
#		   "PERL5LIB" => "/home/jeffpang/Colyseus/scripts/lib:/home/jeffpang/Colyseus/scripts/lib/i686-linux" } ],

#	       "iris-d-06.cmcl.cs.cmu.edu" =>
#	       [ "/misc/ashu/nsdi2005",
#		 "/home/jeffpang/techrep2004/results",
#		 [ "components" ],
#		 { "COL_RESULTS_COMPONENTS" => [ "noprediction" ],
#		   "PERL5LIB" => "/home/jeffpang/Colyseus/scripts/lib:/home/jeffpang/Colyseus/scripts/lib/i686-linux" } ],

	       "great-white.cmcl.cs.cmu.edu" =>
	       [ "/usr2/jeffpang/techrep2004",
		 "/usr2/jeffpang/techrep2004/results",
		 [ "p2p" ],
		 { "COL_RESULTS_P2P" => [ 1,3,5,7,8,10,20,30,40,50 ],
		   "PERL5LIB" => "/usr0/jeffpang/netmap/lib:/usr0/jeffpang/Colyseus/scripts/lib:/usr0/jeffpang/Colyseus/scripts/lib/i686-linux" } ],
	       
	       );

###############################################################################

sub DoAll {
    my ($logdir, $resdir, $expts, $envvars) = @_;

    if ( -e $resdir ) {
	my $index = 1;
	while ( -e "$resdir.old.$index" ) {
	    $index++;
	}
	tinfo "$resdir already exists; moving to $resdir.old.$index";
	psystem("mv -f $resdir $resdir.old.$index");
    }
    if (! -d $logdir ) {
	tdie "no such logdir $logdir";
    }
    psystem("mkdir -p $resdir") && tdie "can't make $resdir";

    $ENV{CVS_RSH} = "ssh";
    $ENV{COL_RESULTS_LOGDIR} = $logdir;
    $ENV{COL_RESULTS_RESDIR} = $resdir;
    $ENV{COL_RESULTS_EXPTS}  = join(",", @$expts);
    foreach my $k (keys %$envvars) {
	my $v;
	if (ref($envvars->{$k}) eq 'ARRAY') {
	    $v = join(",", @{$envvars->{$k}});
	} else {
	    $v = $envvars->{$k};
	}

	$ENV{$k} = $v;
    }

    tinfo "* environment:\n" . 
	thighlight( join("\n", map { $_ = "$_=$ENV{$_}" } keys %ENV) );

    chdir "$ENV{HOME}/Colyseus/scripts" || 
	tdie "can't change dir to ~/Colyseus/scripts";
    #psystem("cvs update") &&
    #	tdie "can't cvs update";
    psystem("make") &&
	tdie "make failed";

    #
    # Colyseus/scripts processing
    #

    #psystem("perl RunallExpMsgLog.pl");
    #psystem("perl RunallSubDiscoveryTime.pl");
    psystem("perl RunallTimeSeries.pl");
    #psystem("perl RunallSubDiscoveryTimeDetailed.pl");
    
    chdir "$ENV{HOME}/Colyseus/scripts" || 
	tdie "can't change dir to ~/Colyseus/scripts";

    #
    # Colyseus/scripts processing
    #

    #psystem("cvs update") &&
    #	tdie "can't cvs update";
    #psystem("perl RunallCSBC.pl");
    #psystem("perl RunallReplicaConsistency.pl");

    tinfo "* done!";
}

###############################################################################

psystem("mkdir -p $SAVEDIR") && tdie "can't create $SAVEDIR";

my @wait;

## kill on interrupt
our $done = 0;
$SIG{INT} = $SIG{TERM} = sub {
    if ($done) { exit(255) }
    $done = 1;

    foreach my $bg (@wait) {
	tinfo "killing $bg->[0] ...";
	$bg->[1]->stop();
	rsystem($USER, $bg->[0], 
		sub { psystem("killall perl /usr/bin/perl >/dev/null 2>&1") });
    }
    exit 255;
};

## start everything
foreach my $c (keys %CONFIG) {
    tinfo "Starting processing on $c...";
    
    my $ssh = new Travertine::SSHTunnel($USER, $c);

    my $bg = ExecRemoteFunc( $ssh, \&DoAll, $CONFIG{$c}, 
			     -background => 1,
			     -log => "/tmp/RunallProcessing.log" );

    if (!$bg) {
	twarn "exec on $c failed!";
    } else {
	push @wait, [ $c, $bg ];
    }
}

sleep(10);

## check liveness
foreach my $bg (@wait) {
    if (!$bg->[1]->isAlive()) {
	twarn "$bg->[0] is dead!";
    }
}

tinfo "Everything started!";

## wait for completion
foreach my $bg (@wait) {
    $bg->[1]->wait();
    tinfo "$bg->[0] completed!";
}

## copy logs to $SAVEDIR
tinfo "copying logs...";
ParallelExec2(sub {
    my $host = shift;
    my $dir = shift;

    psystem("rsync -azb -e ssh '$USER\@$host:$dir/*' $SAVEDIR/");

}, map { $_ = [ $_, $CONFIG{$_}->[1] ] } keys %CONFIG);

tinfo "finished!";

exit 0;
