#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use ResultsConf;

Runall("merc-bwidth", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;

    my $bwscript = "$ENV{HOME}/Colyseus/scripts/MessageLogTimeSeries.pl";
    if ($AGGLOGS) {
	$bwscript = "$ENV{HOME}/Colyseus/scripts/AggMsgLogTimeSeries.pl";
    }
    my $pipe = "";
    
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];

	my @dirs = ( "pub-send",
		     "sub-send",
		     "pub-route",
		     "sub-route",
		     "pub-linear",
		     "sub-linear",
		     "match",
		     #"merc-bwidth",
		     #"routing-bwidth",
		     #"matching-bwidth",
		     #"total-bwidth",
		     #"frame-time",
		     #"numreplicas",
		     #"numreplicas-detailed",
		   );

	foreach my $d (@dirs) {
	    system("rm -rf $outdir/$out/$d/$exp");
	    system("mkdir -p $outdir/$out/$d/$exp");
	}
	
	print STDERR "### Expt -- $exp...\n";
	
	my $start    = GetStartTime($dir);
	my $slowdown = GetSlowDown($dir);
	my @files;
	if ($AGGLOGS) {
		@files = glob("$dir/AggregateMessage*");
	} else {
		@files = glob "$dir/Message*";
	}

	chdir $dir;
	foreach my $f (@files) {
	    $f =~ /(\d+\.\d+\.\d+\.\d+\:\d+)/;
	    my $id = $1;
	    die "bad filename $f" if !$id;

	    my $shopts = "-S $start -s $SKIPTIME -l $LENGTH";
	    my $bwopts = "$shopts -e 0.1 -t proto";
	    my $field = 0;

	    $field = 1 if (!$AGGLOGS);
	    
	    if ($slowdown != 1) {
		$pipe = "$ENV{HOME}/Colyseus/scripts/TimeFilter.pl -S $start -w $slowdown -f $field |";		
	    }
	 
	    system ("cat $f | $pipe $bwscript $bwopts " .
		    "-M 'MSG_RANGE_PUB_NOTROUTING' /dev/stdin > " .
		    "$outdir/$out/pub-send/$exp/$id.log");

	    system ("cat $f | $pipe $bwscript $bwopts " .
		    "-M 'MSG_SUB_NOTROUTING' /dev/stdin > " .
		    "$outdir/$out/sub-send/$exp/$id.log");

	    system ("cat $f | $pipe $bwscript $bwopts " .
		    "-M 'MSG_RANGE_PUB,MSG_PUB' /dev/stdin > " .
		    "$outdir/$out/pub-route/$exp/$id.log");

	    system ("cat $f | $pipe $bwscript $bwopts " .
		    "-M 'MSG_SUB' /dev/stdin > " .
		    "$outdir/$out/sub-route/$exp/$id.log");

	    system ("cat $f | $pipe $bwscript $bwopts " .
		    "-M 'MSG_LINEAR_PUB' /dev/stdin > " .
		    "$outdir/$out/pub-linear/$exp/$id.log");

	    system ("cat $f | $pipe $bwscript $bwopts " .
		    "-M 'MSG_LINEAR_SUB' /dev/stdin > " .
		    "$outdir/$out/sub-linear/$exp/$id.log");

	    system ("cat $f | $pipe $bwscript $bwopts " .
		    "-M 'MSG_MATCHED_PUB,MSG_RANGE_MATCHED_PUB' /dev/stdin >" .
		    "$outdir/$out/match/$exp/$id.log");
	    
	}
    }
}
